package org.jfree.chart.plot.junit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.jfree.chart.plot.*;
import org.jfree.chart.ChartRenderingInfo;

import java.awt.geom.Rectangle2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.IllegalArgumentException;

import org.jfree.chart.entity.HCTreeNodeEntity;
import org.jfree.data.hc.HCTreeNode;
import org.jfree.chart.renderer.RendererState; 
import org.jfree.ui.RectangleEdge;
import org.jfree.chart.plot.HCPlotState;
import org.jfree.chart.plot.HCTreeNodeInfo;
import org.jfree.chart.plot.StandardHCClusteringInfo;

/**
 * Tests for the {@link HCPlotState} class.
 */
public class HCPlotStateTests extends TestCase {

    /**
     * Returns the tests as a test suite.
     *
     * @return The test suite.
     */
    public static Test suite() {
        return new TestSuite(HCPlotStateTests.class);
    }

    /**
     * Constructs a new set of tests.
     *
     * @param name  the name of the tests.
     */
    public HCPlotStateTests(String name) {
        super(name);
    }

    /**
     * Tests everything.
     */
    public void testEverything(){

	PlotRenderingInfo info = new PlotRenderingInfo(new ChartRenderingInfo());
	HCTreeNode node = new HCTreeNode(1.0);
	StandardHCClusteringInfo cInfo = new StandardHCClusteringInfo(node, new String[] {"names","names"}, 1);
	HCTreeNodeInfo hcinfo = new HCTreeNodeInfo(cInfo, node);

	HCTreeNodeEntity entity = new HCTreeNodeEntity(new Rectangle(), 
							   "tooltip", 
							    "url", 
							    new Point(),
							    new Rectangle(),
							    hcinfo); 

	HCTreeNodeEntity entity2 = new HCTreeNodeEntity(new Rectangle(), 
							   "tooltip", 
							    "url", 
							    new Point(),
							    new Rectangle(),
							    hcinfo); 
	

	int blockMinX = 1;
        int blockMinY = 2;
        int sizeOfNodeSymbol = 3;
        double blockWidth = 4.0;
        double blockHeight = 5.0;
        double columnTreeHeightUnitInPixels = 6.0;
        double rowTreeHeightUnitInPixels = 7.0;


	HCPlotState pState = new HCPlotState(info, 
					     blockMinX, 
					     blockMinY, 
					     sizeOfNodeSymbol,
					     blockWidth, 
					     blockHeight,
					     columnTreeHeightUnitInPixels,
					     rowTreeHeightUnitInPixels);
	
	assertEquals(sizeOfNodeSymbol, pState.getSizeOfNodeSymbol());
	assertTrue(blockWidth == pState.getBlockWidth());
	assertTrue(blockHeight == pState.getBlockHeight());
	assertTrue(columnTreeHeightUnitInPixels == pState.getColumnTreeHeightUnitInPixels());
	assertTrue(rowTreeHeightUnitInPixels == pState.getRowTreeHeightUnitInPixels());
	assertEquals((int)(2*blockWidth+blockMinX), pState.getHeatMapXCoordinate(2));
	assertEquals((int)(3*blockHeight+blockMinY), pState.getHeatMapYCoordinate(3));


	RectangleEdge location;

	//testing different edge locations on every method.
	
	location = null;

	try {
		Rectangle rct = pState.calculateSubTreeArea(new Rectangle(), new Rectangle(), location);
	} catch (IllegalArgumentException e){
		
		IllegalArgumentException e2 = new IllegalArgumentException("Invalid edge.");
		assertTrue(e.toString().equals(e2.toString()));
	}

	try {
		Point p = pState.calculateBranchNodeCenter(1.0, 
						 	  entity,
						  	  entity2,
						  	  new Rectangle(),
						  	  location);
	} catch (IllegalArgumentException ex){

		IllegalArgumentException ex2 = new IllegalArgumentException("Invalid edge.");
		assertTrue(ex.toString().equals(ex2.toString()));
	}

	try {
		Rectangle r = pState.calculateBranchNodeArea(1.0, 
						 	  entity,
						  	  entity2,
						  	  new Rectangle(),
						  	  location);
	} catch (IllegalArgumentException ex3){

		IllegalArgumentException ex4 = new IllegalArgumentException("Invalid edge.");
		assertTrue(ex3.toString().equals(ex4.toString()));
	}

	try {
		Rectangle rct2 = pState.calculateLeafNodeArea(new Rectangle(), hcinfo, location);
	} catch (IllegalArgumentException e3){
		
		IllegalArgumentException e4 = new IllegalArgumentException("Invalid edge.");
		assertTrue(e3.toString().equals(e4.toString()));
	}

	try {
		Point p2 = pState.calculateLeafNodeCenter(new Rectangle(), location);
	} catch (IllegalArgumentException e5){
		
		IllegalArgumentException e6 = new IllegalArgumentException("Invalid edge.");
		assertTrue(e5.toString().equals(e6.toString()));
	}

	try {
		Point p3 = pState.calculateClosedNodeCenter(new Rectangle(), 1.0, location);
	} catch (IllegalArgumentException e7){
		
		IllegalArgumentException e8 = new IllegalArgumentException("Invalid edge.");
		assertTrue(e7.toString().equals(e8.toString()));
	}

	try {
		Rectangle rct3 = pState.calculateClosedNodeArea(new Rectangle(), hcinfo, location);
	} catch (IllegalArgumentException exc){

		IllegalArgumentException exc2 = new IllegalArgumentException("Invalid edge.");
		assertTrue(exc.toString().equals(exc2.toString()));
	}



	location = RectangleEdge.TOP;
	Rectangle rct = pState.calculateSubTreeArea(new Rectangle(), new Rectangle(), location);

	Point p = pState.calculateBranchNodeCenter(1.0, 
						  entity,
						  entity2,
						  new Rectangle(),
						  location);

	Rectangle r  = pState.calculateBranchNodeArea(1.0, 
						  entity,
						  entity2,
						  new Rectangle(),
						  location);

	Rectangle rct2 = pState.calculateLeafNodeArea(new Rectangle(), hcinfo, location);	
	Point p2 = pState.calculateLeafNodeCenter(new Rectangle(), location);
	Point p3 = pState.calculateClosedNodeCenter(new Rectangle(), 1.0, location);

	

	location = RectangleEdge.BOTTOM;
	rct = pState.calculateSubTreeArea(new Rectangle(), new Rectangle(), location);

	p = pState.calculateBranchNodeCenter(1.0, 
					    entity,
					    entity2,
					    new Rectangle(),
				            location);

	r  = pState.calculateBranchNodeArea(1.0, 
						  entity,
						  entity2,
						  new Rectangle(),
						  location);

	rct2 = pState.calculateLeafNodeArea(new Rectangle(), hcinfo, location);	
	p2 = pState.calculateLeafNodeCenter(new Rectangle(), location);
	p3 = pState.calculateClosedNodeCenter(new Rectangle(), 1.0, location);

	location = RectangleEdge.LEFT;	
	rct = pState.calculateSubTreeArea(new Rectangle(), new Rectangle(), location);
	
	p = pState.calculateBranchNodeCenter(1.0, 
					    entity,
					    entity2,
					    new Rectangle(),
  					    location);

	r  = pState.calculateBranchNodeArea(1.0, 
						  entity,
						  entity2,
						  new Rectangle(),
						  location);

	rct2 = pState.calculateLeafNodeArea(new Rectangle(), hcinfo, location);	
	p2 = pState.calculateLeafNodeCenter(new Rectangle(), location);
	p3 = pState.calculateClosedNodeCenter(new Rectangle(), 1.0, location);


	location = RectangleEdge.RIGHT;
	rct = pState.calculateSubTreeArea(new Rectangle(), new Rectangle(), location);

	p = pState.calculateBranchNodeCenter(1.0, 
					    entity,
					    entity2,
					    new Rectangle(),
					    location);

	r  = pState.calculateBranchNodeArea(1.0, 
						  entity,
						  entity2,
						  new Rectangle(),
						  location);
	
	rct2 = pState.calculateLeafNodeArea(new Rectangle(), hcinfo, location);	
	p2 = pState.calculateLeafNodeCenter(new Rectangle(), location);
	p3 = pState.calculateClosedNodeCenter(new Rectangle(), 1.0, location);
	
	

    }

    /**
     * Test wrong parameter values.
     */
    public void testWrong(){

	PlotRenderingInfo info = new PlotRenderingInfo(new ChartRenderingInfo());
	HCTreeNode node = new HCTreeNode(1.0);
	StandardHCClusteringInfo cInfo = new StandardHCClusteringInfo(node, new String[] {"names","names"}, 1);
	HCTreeNodeInfo hcinfo = new HCTreeNodeInfo(cInfo, node);

	HCTreeNodeEntity entity = new HCTreeNodeEntity(new Rectangle(), 
							   "tooltip", 
							    "url", 
							    new Point(),
							    new Rectangle(),
							    hcinfo); 

	int blockMinX = 1;
        int blockMinY = 2;
        int sizeOfNodeSymbol = 3;
        double blockWidth = 4.0;
        double blockHeight = 5.0;
        double columnTreeHeightUnitInPixels = 6.0;
        double rowTreeHeightUnitInPixels = 7.0;
	
	HCPlotState pState = new HCPlotState(info, 
					     blockMinX, 
					     blockMinY, 
					     sizeOfNodeSymbol,
					     blockWidth, 
					     blockHeight,
					     columnTreeHeightUnitInPixels,
					     rowTreeHeightUnitInPixels);

	HCPlotState pState2;

	// null value
	try {
	  pState2 = new HCPlotState(null, 
			 	     blockMinX, 
				     blockMinY, 
				     sizeOfNodeSymbol,
				     blockWidth, 
				     blockHeight,
				     columnTreeHeightUnitInPixels,
				     rowTreeHeightUnitInPixels);
	} catch (Exception e){
	  assertTrue(false);
	}

	// freaky indeces
	try {
	  pState.getHeatMapXCoordinate(Integer.MIN_VALUE);
	} catch (Exception e){	  
	  assertTrue(false);
 	}

	// freaky indeces
	try {
	  pState.getHeatMapXCoordinate(Integer.MAX_VALUE);
	} catch (Exception e){
	  assertTrue(false);
	}

	// freaky indeces
	try {
	  pState.getHeatMapYCoordinate(Integer.MIN_VALUE);
	} catch (Exception e){
	  assertTrue(false);
	}

	// freaky indeces
	try {
	  pState.getHeatMapXCoordinate(Integer.MAX_VALUE);
	} catch (Exception e){
	  assertTrue(false);
	}

   }
}
