/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.xml;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.util.ObjectHelper;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractCamelEndpointFactoryBean
extends IdentifiedType
implements CamelContextAware {
    @XmlAttribute
    @Deprecated
    private Boolean singleton = Boolean.FALSE;
    @XmlAttribute
    private String uri;
    @XmlAttribute
    private String camelContextId;
    @XmlTransient
    private CamelContext context;
    @XmlTransient
    private Endpoint endpoint;

    public Object getObject() throws Exception {
        if (this.endpoint == null || !this.endpoint.isSingleton()) {
            if (this.context == null && this.camelContextId != null) {
                this.context = this.getCamelContextWithId(this.camelContextId);
            }
            ObjectHelper.notNull((Object)this.context, (String)"context");
            ObjectHelper.notNull((Object)this.uri, (String)"uri");
            this.endpoint = this.context.getEndpoint(this.uri);
            if (this.endpoint == null) {
                throw new NoSuchEndpointException(this.uri);
            }
        }
        return this.endpoint;
    }

    protected abstract CamelContext getCamelContextWithId(String var1);

    public Class getObjectType() {
        return Endpoint.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void setSingleton(boolean singleton) {
    }

    public CamelContext getCamelContext() {
        return this.context;
    }

    public void setCamelContext(CamelContext context) {
        this.context = context;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getCamelContextId() {
        return this.camelContextId;
    }

    public void setCamelContextId(String camelContextId) {
        this.camelContextId = camelContextId;
    }
}

