/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.description;

import fi.csc.microarray.description.SADLParser;
import java.util.LinkedList;
import java.util.List;

public class SADLTokeniser {
    private List<String> tokens;
    private List<TokenType> types;
    int index = -1;

    public SADLTokeniser(String sadl, String unitName) throws SADLParser.ParseException {
        CharTokeniser t = new CharTokeniser(sadl, unitName);
        t.tokenise();
        this.tokens = t.getTokens();
        this.types = t.getTypes();
        if (this.tokens.size() != this.types.size()) {
            throw new RuntimeException("internal parsing error, number of types and tokens does not match");
        }
    }

    public String peek() {
        if (!this.hasNext()) {
            return null;
        }
        return this.tokens.get(this.index + 1);
    }

    public TokenType peekType() {
        if (!this.hasNext()) {
            return null;
        }
        return this.types.get(this.index + 1);
    }

    public boolean hasNext() {
        return this.index + 1 < this.tokens.size();
    }

    public String next() {
        if (!this.hasNext()) {
            throw new RuntimeException("tokeniser error: no tokens left (there were " + this.tokens.size() + " tokens)");
        }
        return this.tokens.get(++this.index);
    }

    public static String[] blockEndingOperators() {
        return new String[]{"\"", ")"};
    }

    public static String[] tokenEndingOperators() {
        return new String[]{":", "[", "]", ","};
    }

    private static class CharTokeniser {
        private String sadl;
        private int charIndex = 0;
        private String unitName;
        private boolean escaped;
        private boolean escapingEnabled;
        private List<String> tokens = new LinkedList<String>();
        private List<TokenType> types = new LinkedList<TokenType>();

        public CharTokeniser(String sadl, String unitName) {
            this.sadl = sadl;
            this.unitName = unitName;
        }

        public void tokenise() throws SADLParser.ParseException {
            while (!this.atEnd()) {
                int startedAt = this.charIndex;
                String token = "";
                TokenType type = TokenType.NORMAL;
                if (this.peek() == "(".charAt(0)) {
                    this.next();
                    this.setEscapingEnabled(true);
                    while (!this.atEnd() && !this.isOperator(")".charAt(0))) {
                        token = token + this.next();
                    }
                    this.setEscapingEnabled(false);
                    this.next();
                    type = TokenType.COMMENT;
                } else if (this.peek() == "\"".charAt(0)) {
                    this.next();
                    this.setEscapingEnabled(true);
                    while (!this.atEnd() && !this.isOperator("\"".charAt(0))) {
                        token = token + this.next();
                    }
                    this.setEscapingEnabled(false);
                    this.next();
                    type = TokenType.QUOTED;
                } else if (this.isOperator()) {
                    while (!this.atEnd() && this.isOperator()) {
                        token = token + this.next();
                    }
                    type = TokenType.OPERATOR;
                } else {
                    while (!(this.atEnd() || this.isWhiteSpace() || this.isOperator())) {
                        token = token + this.next();
                    }
                }
                while (!this.atEnd() && this.isWhiteSpace()) {
                    this.next();
                }
                if (this.charIndex == startedAt) {
                    throw new SADLParser.ParseException("tokeniser got stuck at ", this.unitName);
                }
                this.tokens.add(token);
                this.types.add(type);
            }
        }

        public List<String> getTokens() {
            return this.tokens;
        }

        public List<TokenType> getTypes() {
            return this.types;
        }

        private void setEscapingEnabled(boolean b) {
            this.escapingEnabled = true;
        }

        private boolean atEnd() {
            return this.charIndex >= this.sadl.length();
        }

        private boolean isWhiteSpace() {
            char c = this.peek();
            return Character.isWhitespace(c);
        }

        private boolean isOperator(char operator) {
            boolean isOperator;
            boolean bl = isOperator = this.peek() == operator;
            if (this.escaped) {
                return false;
            }
            return isOperator;
        }

        private boolean isOperator() {
            char c = this.peek();
            if (this.escaped) {
                return false;
            }
            for (String operator : SADLTokeniser.tokenEndingOperators()) {
                if (c != operator.charAt(0)) continue;
                return true;
            }
            return false;
        }

        public char next() {
            char c = this.peek();
            ++this.charIndex;
            return c;
        }

        public char peek() {
            this.escaped = false;
            if (this.escapingEnabled && this.sadl.charAt(this.charIndex) == "\\".charAt(0)) {
                ++this.charIndex;
                this.escaped = true;
            }
            return this.sadl.charAt(this.charIndex);
        }
    }

    public static enum TokenType {
        COMMENT,
        QUOTED,
        OPERATOR,
        NORMAL;

    }
}

