/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserConstants;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReadPileTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReadpartDataProvider;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.BaseStorage;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class CoverageTrack
extends Track {
    private long maxBpLength;
    private long minBpLength;
    private Color forwardColor;
    private Color reverseColor;
    private boolean highlightSNP = false;
    private BaseStorage theBaseCacheThang = new BaseStorage();
    private AreaRequestHandler refFile;
    private Collection<RegionContent> refReads = new TreeSet<RegionContent>();
    private ReadpartDataProvider readpartProvider;

    public CoverageTrack(ReadpartDataProvider readpartProvider, AreaRequestHandler refFile, Color forwardColor, Color reverseColor, long minBpLength, long maxBpLength) {
        this.forwardColor = forwardColor;
        this.reverseColor = reverseColor;
        this.minBpLength = minBpLength;
        this.maxBpLength = maxBpLength;
        this.readpartProvider = readpartProvider;
        this.setStrand(Strand.BOTH);
        this.refFile = refFile;
    }

    @Override
    public void initializeListener() {
        super.initializeListener();
        if (this.areaRequestHandler != null && this.refFile != null) {
            this.view.getQueueManager().addResultListener(this.refFile, this);
        }
    }

    private Collection<Drawable> getDrawableReads(Strand dataStrand, Color color) {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        Chromosome chr = this.getView().getBpRegion().start.chr;
        char[] refSeq = ReadPileTrack.getReferenceArray(this.refReads, this.view, Strand.FORWARD);
        this.theBaseCacheThang.getNucleotideCounts(this.readpartProvider.getReadparts(dataStrand), this.view, refSeq);
        float bpWidth = (float)((double)this.getView().getWidth() / this.getView().getBpRegionDouble().getLength());
        int bottomlineY = 0;
        Iterator<BaseStorage.Base> bases = this.theBaseCacheThang.iterator();
        int previousValueY = 0;
        int previousEndX = -1;
        Color lineColor = new Color(color.getRGB(), false);
        while (bases.hasNext()) {
            BaseStorage.Base currentBase = bases.next();
            float startX = this.getView().bpToTrackFloat(new BpCoord(currentBase.getBpLocation(), chr)).floatValue();
            int width = (int)(startX + bpWidth) - (int)startX;
            int profileY = currentBase.getCoverage();
            int valueY = bottomlineY + profileY;
            drawables.add(new RectDrawable((int)startX, bottomlineY, width, valueY, color, null));
            if (previousEndX < (int)startX) {
                drawables.add(new LineDrawable(previousEndX, bottomlineY, previousEndX, previousValueY, lineColor));
                previousValueY = 0;
            }
            drawables.add(new LineDrawable((int)startX, previousValueY, (int)startX, valueY, lineColor));
            drawables.add(new LineDrawable((int)startX, valueY, (int)startX + width, valueY, lineColor));
            this.drawSNPBar(drawables, (int)bpWidth, bottomlineY, currentBase, (int)startX);
            previousValueY = valueY;
            previousEndX = (int)startX + width;
        }
        drawables.add(new LineDrawable(previousEndX, bottomlineY, previousEndX, previousValueY, lineColor));
        return drawables;
    }

    private void drawSNPBar(Collection<Drawable> drawables, int bpWidth, int bottomlineY, BaseStorage.Base currentBase, int endX) {
        if (this.highlightSNP && currentBase.hasSignificantSNPs()) {
            int y = bottomlineY;
            for (BaseStorage.Nucleotide nt : BaseStorage.Nucleotide.values()) {
                int increment = currentBase.getSNPCounts()[nt.ordinal()];
                if (increment <= 0) continue;
                Color c = GBrowserConstants.charColors[nt.ordinal()];
                drawables.add(new RectDrawable(endX, y, bpWidth, increment, c, null));
                y += increment;
            }
        }
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        if (this.reverseColor == null) {
            drawables.addAll(this.getDrawableReads(Strand.BOTH, this.forwardColor));
        } else {
            drawables.addAll(this.getDrawableReads(Strand.FORWARD, this.forwardColor));
            drawables.addAll(this.getDrawableReads(Strand.REVERSE, this.reverseColor));
        }
        return drawables;
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
        if (areaResult.getStatus().areaRequestHandler == this.refFile) {
            this.refReads.addAll(areaResult.getContents());
        }
    }

    @Override
    public int getHeight() {
        return 100;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.getView().getBpRegion().getLength() > this.minBpLength && this.getView().getBpRegion().getLength() <= this.maxBpLength;
    }

    @Override
    public Map<AreaRequestHandler, Set<ColumnType>> requestedData() {
        HashMap<AreaRequestHandler, Set<ColumnType>> datas = new HashMap<AreaRequestHandler, Set<ColumnType>>();
        datas.put(this.areaRequestHandler, new HashSet<ColumnType>(Arrays.asList(ColumnType.COVERAGE)));
        if (this.highlightSNP && this.getView().getBpRegion().getLength() < (long)(this.getView().getWidth() * 2)) {
            datas.put(this.refFile, new HashSet<ColumnType>(Arrays.asList(ColumnType.SEQUENCE)));
        }
        return datas;
    }

    @Override
    public boolean canExpandDrawables() {
        return true;
    }

    public void enableSNPHighlight() {
        this.highlightSNP = true;
    }

    public void disableSNPHighlight() {
        this.highlightSNP = false;
    }
}

