/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.message;

import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;

public class Region
implements Comparable<Region> {
    public BpCoord start;
    public BpCoord end;
    @Deprecated
    public Strand strand;

    public Region(BpCoord start, BpCoord end) {
        this.start = start;
        this.end = end;
    }

    @Deprecated
    public Region(BpCoord start, BpCoord end, Strand strand) {
        this.start = start;
        this.end = end;
        this.strand = strand;
    }

    @Deprecated
    public Region(Long start, Long end, Chromosome chr, Strand strand) {
        this.start = new BpCoord(start, chr);
        this.end = new BpCoord(end, chr);
        this.strand = strand;
    }

    public Region(Long start, Long end, Chromosome chr) {
        this.start = new BpCoord(start, chr);
        this.end = new BpCoord(end, chr);
    }

    public Region(Long start, Chromosome chr1, Long end, Chromosome chr2) {
        this.start = new BpCoord(start, chr1);
        this.end = new BpCoord(end, chr2);
    }

    public Region() {
        this(null, null);
    }

    public Region(Region bpRegion) {
        this(new BpCoord(bpRegion.start), new BpCoord(bpRegion.end));
    }

    public Long getLength() {
        return this.end.minus(this.start);
    }

    public Long getMid() {
        return this.start.plus(this.end) / 2L;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean tsvFormat) {
        if (tsvFormat) {
            return this.start.chr + "\t" + this.start.bp + "\t" + this.end.bp;
        }
        return "Region [" + this.start + " - " + this.end + "]";
    }

    public Region clone() throws CloneNotSupportedException {
        return new Region(this.start.clone(), this.end.clone(), this.strand);
    }

    @Override
    public int compareTo(Region o) {
        int startComparison = this.start.compareTo(o.start);
        if (startComparison != 0) {
            return startComparison;
        }
        return this.end.compareTo(o.end);
    }

    public boolean equals(Object o) {
        if (o instanceof Region) {
            Region other = (Region)o;
            return this.start.equals(other.start) && this.end.equals(other.end);
        }
        return false;
    }

    public int hashCode() {
        return this.start.hashCode();
    }

    public boolean contains(BpCoord point) {
        return this.start.chr.equals(point.chr) && point.compareTo(this.start) >= 0 && point.compareTo(this.end) < 0;
    }

    public boolean intersects(Region other) {
        BpCoord intersectionEnd;
        BpCoord intersectionStart = this.start.max(other.start);
        return intersectionStart.compareTo(intersectionEnd = this.end.min(other.end)) <= 0;
    }

    public Region intersect(Region other) {
        if (!this.intersects(other)) {
            throw new IllegalArgumentException("regions do not intersect");
        }
        return new Region(this.start.max(other.start), this.end.min(other.end));
    }

    public Region merge(Region other) {
        if (!this.intersects(other)) {
            throw new IllegalArgumentException("regions do not intersect");
        }
        return new Region(this.start.min(other.start), this.end.max(other.end));
    }

    public Region fill(Region other) {
        BpCoord left = this.start.min(this.end.min(other.start.min(other.end)));
        BpCoord right = this.start.max(this.end.max(other.start.max(other.end)));
        return new Region(left, right, this.strand);
    }

    public Strand getStrand() {
        return this.strand;
    }
}

