/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.message;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Transcript;

public class Exon
implements Comparable<Exon> {
    private Region region;
    private Feature feature;
    private int exonNumber;
    private Transcript transcript;

    private Feature getFeature(String id) {
        for (Feature feature : Feature.values()) {
            if (feature.getId() == null || !feature.getId().equals(id)) continue;
            return feature;
        }
        return Feature.UNRECOGNIZED;
    }

    public Exon(Region region, String feature, int exonNumber) {
        this.region = region;
        this.feature = this.getFeature(feature);
        this.exonNumber = exonNumber;
    }

    @Override
    public int compareTo(Exon other) {
        int transcriptComparison = this.transcript.compareTo(other.transcript);
        int featureComparison = this.feature.compareTo(other.feature);
        int startComparison = this.region.start.compareTo(other.region.start);
        if (transcriptComparison != 0) {
            return transcriptComparison;
        }
        if (featureComparison != 0) {
            return featureComparison;
        }
        return startComparison;
    }

    private Object getExonNumber() {
        return this.exonNumber;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public int hashCode() {
        return this.transcript.hashCode() << 8 + this.exonNumber << 2 + this.feature.ordinal();
    }

    public boolean equals(Object o) {
        if (o instanceof Exon) {
            return this.compareTo((Exon)o) == 0;
        }
        return false;
    }

    public String toString() {
        return this.region.toString(true) + ", " + (Object)((Object)this.feature);
    }

    public Region getRegion() {
        return this.region;
    }

    public Integer getIndex() {
        return this.exonNumber;
    }

    public void setTranscript(Transcript transc) {
        this.transcript = transc;
    }

    public static enum Feature {
        UNRECOGNIZED(null),
        TRANSCRIPT("transcript"),
        EXON("exon"),
        CDS("CDS"),
        START_CODON("start_codon"),
        STOP_CODON("stop_codon");

        private String id;

        private Feature(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

