/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.gui;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserPlot;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutComponent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutContainer;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutTool;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.RegionListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.ScrollGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.TooltipAugmentedChartPanel;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.ViewLimiter;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoordDouble;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataRetrievalStatus;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.QueueManager;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionDouble;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public abstract class GBrowserView
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
TooltipAugmentedChartPanel.TooltipRequestProcessor,
LayoutComponent,
LayoutContainer {
    public RegionDouble bpRegion;
    public Region highlight;
    public Collection<ScrollGroup> scrollGroups = new LinkedList<ScrollGroup>();
    protected Rectangle viewArea = new Rectangle(0, 0, 500, 500);
    private QueueManager queueManager;
    private Point2D dragStartPoint;
    private boolean dragStarted;
    public GBrowserPlot parentPlot;
    protected static final int FPS = 30;
    protected boolean movable;
    protected boolean zoomable;
    protected final float ZOOM_FACTOR = 1.06f;
    protected final float MIN_PIXELS_PER_NUCLEOTIDE = 10.0f;
    private List<RegionListener> listeners = new LinkedList<RegionListener>();
    public int margin = 0;
    private Point2D dragEndPoint;
    private Point2D dragLastStartPoint;
    private long dragEventTime;
    private static final long DRAG_EXPIRATION_TIME_MS = 50L;
    private Timer mouseAnimationTimer;
    private ViewLimiter viewLimiter;
    private int layoutHeight;

    public GBrowserView(GBrowserPlot parent, boolean movable, boolean zoomable, boolean selectable) {
        this.parentPlot = parent;
        this.movable = movable;
        this.zoomable = zoomable;
    }

    protected abstract void drawDrawable(Graphics2D var1, int var2, int var3, Drawable var4);

    public void addTrackGroup(TrackGroup group) {
        ScrollGroup scrollGroup = new ScrollGroup();
        scrollGroup.addTrackGroup(group);
        this.scrollGroups.add(scrollGroup);
    }

    public Collection<Track> getTracks() {
        LinkedList<Track> tracks = new LinkedList<Track>();
        for (ScrollGroup scrollGroup : this.scrollGroups) {
            for (TrackGroup trackGroup : scrollGroup.getTrackGroups()) {
                if (!trackGroup.isVisible()) continue;
                tracks.addAll(trackGroup.getTracks());
            }
        }
        return tracks;
    }

    public void draw(Graphics2D g, Rectangle plotArea, Rectangle viewArea) {
        this.viewArea = (Rectangle)viewArea.clone();
        if (viewArea.height == 0) {
            return;
        }
        if (this.bpRegion == null) {
            this.setBpRegion(new RegionDouble(0.0, 2.62144E8, new Chromosome("1")));
        }
        Rectangle scrollGroupViewPort = (Rectangle)viewArea.clone();
        for (ScrollGroup scrollGroup : this.scrollGroups) {
            scrollGroupViewPort.height = scrollGroup.getHeight();
            scrollGroup.draw(g, plotArea, scrollGroupViewPort, this);
            scrollGroupViewPort.y += scrollGroupViewPort.height;
        }
        if (this.isCursorLineEnabled()) {
            g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.25f));
            g.drawLine((int)plotArea.getWidth() / 2, 0, (int)plotArea.getWidth() / 2, (int)plotArea.getHeight());
        }
    }

    public boolean isCursorLineEnabled() {
        return true;
    }

    public int getWidth() {
        return this.viewArea.width;
    }

    @Override
    public int getHeight() {
        return LayoutTool.getHeight(this, this.layoutHeight);
    }

    public QueueManager getQueueManager() {
        if (this.queueManager == null) {
            this.queueManager = new QueueManager();
        }
        return this.queueManager;
    }

    public void fireAreaRequests() {
        HashMap<AreaRequestHandler, Set> datas = new HashMap<AreaRequestHandler, Set>();
        for (Track t : this.getTracks()) {
            Map<AreaRequestHandler, Set<ColumnType>> trackDatas = t.requestedData();
            if (trackDatas == null || !t.isVisible()) continue;
            for (AreaRequestHandler file : trackDatas.keySet()) {
                if (file == null) continue;
                Set columns = (Set)datas.get(file);
                columns = columns != null ? columns : new HashSet();
                columns.addAll(trackDatas.get(file));
                datas.put(file, columns);
            }
        }
        Region requestRegion = this.getBpRegion();
        for (AreaRequestHandler file : datas.keySet()) {
            DataRetrievalStatus status = new DataRetrievalStatus();
            status.clearQueues = true;
            this.getQueueManager().addAreaRequest(file, new AreaRequest(requestRegion, (Collection)datas.get(file), status), true);
        }
    }

    public long getMinBp(long length) {
        return -length / 30L;
    }

    public long getMaxBp(long length) {
        return (long)((double)length * 1.0333333333333334);
    }

    public void setBpRegion(RegionDouble region) {
        this.bpRegion = this.limitRegion(region);
        this.fireAreaRequests();
        this.dispatchRegionChange();
    }

    public RegionDouble getBpRegionDouble() {
        return this.bpRegion;
    }

    public Region getBpRegion() {
        return new Region((Long)((long)this.bpRegion.start.bp.doubleValue()), this.bpRegion.start.chr, (long)Math.ceil(this.bpRegion.end.bp), this.bpRegion.end.chr);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.parentPlot.chartPanel.requestFocusInWindow();
        this.stopAnimation();
        this.dragStartPoint = this.scale(e.getPoint());
        this.dragStarted = false;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.dragStarted && this.dragEndPoint != null && this.dragLastStartPoint != null && Math.abs(this.dragEndPoint.getX() - this.dragLastStartPoint.getX()) > 10.0 && System.currentTimeMillis() - this.dragEventTime < 50L) {
            this.stopAnimation();
            this.mouseAnimationTimer = new Timer(33, new ActionListener(){
                private int i = 2;
                private int ANIMATION_FRAMES = 30;
                private long startTime = System.currentTimeMillis();

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    boolean skipFrame = false;
                    boolean done = false;
                    do {
                        double endX = GBrowserView.this.dragEndPoint.getX();
                        double startX = GBrowserView.this.dragLastStartPoint.getX();
                        double newX = endX - (endX - startX) / (double)(this.ANIMATION_FRAMES - this.i);
                        GBrowserView.this.dragEndPoint = new Point2D.Double(newX, GBrowserView.this.dragEndPoint.getY());
                        skipFrame = this.i < this.ANIMATION_FRAMES - 1 && System.currentTimeMillis() > this.startTime + (long)(33 * this.i);
                        boolean bl = done = this.i >= this.ANIMATION_FRAMES;
                        if (!done) {
                            GBrowserView.this.handleDrag(GBrowserView.this.dragLastStartPoint, GBrowserView.this.dragEndPoint, skipFrame);
                            ++this.i;
                            continue;
                        }
                        GBrowserView.this.stopAnimation();
                    } while (skipFrame && !done);
                }
            });
            this.mouseAnimationTimer.setCoalesce(true);
            this.mouseAnimationTimer.setRepeats(true);
            this.mouseAnimationTimer.start();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.movable && (this.dragStartPoint != null && this.viewArea.contains(this.dragStartPoint) || this.viewArea.contains(e.getPoint()))) {
            this.dragStarted = true;
            this.dragEndPoint = this.scale(e.getPoint());
            this.dragEventTime = System.currentTimeMillis();
            this.handleDrag(this.dragStartPoint, this.dragEndPoint, false);
        }
        this.dragLastStartPoint = this.dragStartPoint;
        this.dragStartPoint = this.scale(e.getPoint());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    protected abstract void handleDrag(Point2D var1, Point2D var2, boolean var3);

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.zoomAnimation((int)this.scale(e.getPoint()).getX(), e.getWheelRotation());
    }

    public void zoomAnimation(final int centerX, final int wheelRotation) {
        this.stopAnimation();
        this.mouseAnimationTimer = new Timer(33, new ActionListener(){
            private int i = 2;
            private long startTime = System.currentTimeMillis();
            private int ANIMATION_FRAMES = 15;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                boolean skipFrame = this.i < this.ANIMATION_FRAMES - 1 && System.currentTimeMillis() > this.startTime + (long)(33 * this.i);
                boolean done = false;
                do {
                    boolean bl = done = this.i >= this.ANIMATION_FRAMES;
                    if (!done) {
                        GBrowserView.this.zoom(centerX, wheelRotation, skipFrame);
                        ++this.i;
                        continue;
                    }
                    GBrowserView.this.stopAnimation();
                } while (skipFrame && !done);
            }
        });
        this.mouseAnimationTimer.setRepeats(true);
        this.mouseAnimationTimer.setCoalesce(true);
        this.mouseAnimationTimer.start();
    }

    private void stopAnimation() {
        if (this.mouseAnimationTimer != null) {
            this.mouseAnimationTimer.stop();
            this.mouseAnimationTimer = null;
        }
    }

    protected void zoom(int lockedX, double wheelRotation, boolean disableDrawing) {
        if (this.zoomable) {
            int minBpWidth;
            BpCoordDouble pointerBp = this.trackToBp(lockedX);
            double pointerRelative = this.trackToRelative(lockedX);
            double startBp = this.getBpRegionDouble().start.bp;
            double endBp = this.getBpRegionDouble().end.bp;
            double width = endBp - startBp;
            if ((width *= Math.pow(1.06f, wheelRotation)) < (double)(minBpWidth = (int)((float)this.parentPlot.chartPanel.getPreferredSize().getSize().width / 10.0f))) {
                width = minBpWidth;
            }
            startBp = pointerBp.bp - width * pointerRelative;
            endBp = pointerBp.bp + width * (1.0 - pointerRelative);
            this.setBpRegion(new RegionDouble(startBp, this.getBpRegionDouble().start.chr, endBp, this.getBpRegionDouble().end.chr));
            if (!disableDrawing) {
                this.parentPlot.redraw();
            }
        }
    }

    public Integer bpToTrack(BpCoord bp) {
        if (this.bpRegion.start.chr.equals(bp.chr)) {
            return (int)Math.round(((double)bp.bp.longValue() - this.getBpRegionDouble().start.bp) * (double)this.bpWidth().floatValue() + (double)this.getX());
        }
        return null;
    }

    public Float bpToTrackFloat(BpCoord bp) {
        if (this.bpRegion.start.chr.equals(bp.chr)) {
            return Float.valueOf((float)(((double)bp.bp.longValue() - this.getBpRegionDouble().start.bp) * (double)this.bpWidth().floatValue()) + (float)this.getX());
        }
        return null;
    }

    public Float bpWidth() {
        return Float.valueOf((float)this.getWidth() / (float)this.getBpRegionDouble().getLength());
    }

    public BpCoordDouble trackToBp(double d) {
        return new BpCoordDouble(this.trackToRelative(d) * (this.getBpRegionDouble().end.bp - this.getBpRegionDouble().start.bp) + this.getBpRegionDouble().start.bp, this.bpRegion.start.chr);
    }

    public double trackToRelative(double track) {
        return (track - (double)this.getX()) / (double)this.getWidth();
    }

    public int getX() {
        return this.viewArea.x;
    }

    public int getY() {
        return this.viewArea.y;
    }

    public void redraw() {
        if (this.mouseAnimationTimer == null || !this.mouseAnimationTimer.isRunning()) {
            this.parentPlot.redraw();
        }
    }

    public void addRegionListener(RegionListener listener) {
        this.listeners.add(listener);
    }

    public void dispatchRegionChange() {
        for (RegionListener listener : this.listeners) {
            listener.regionChanged(this.getBpRegion());
        }
    }

    private Point2D scale(Point2D p) {
        return new Point((int)(p.getX() / this.parentPlot.chartPanel.getScaleX()), (int)(p.getY() / this.parentPlot.chartPanel.getScaleY()));
    }

    @Override
    public String tooltipRequest(MouseEvent mouseEvent) {
        Point locationOnPanel = (Point)mouseEvent.getLocationOnScreen().clone();
        SwingUtilities.convertPointFromScreen(locationOnPanel, (Component)((Object)this.parentPlot.chartPanel));
        return this.tooltipRequest(locationOnPanel);
    }

    public String tooltipRequest(Point2D locationOnPanel) {
        return null;
    }

    public void clean() {
        if (this.queueManager != null) {
            this.queueManager.poisonAll();
        }
        this.scrollGroups.clear();
        this.queueManager = null;
    }

    public void setViewLimiter(ViewLimiter viewLimiter) {
        this.viewLimiter = viewLimiter;
        viewLimiter.addLimitChangeListener(new RegionListener(){

            @Override
            public void regionChanged(Region bpRegion) {
                GBrowserView.this.setBpRegion(GBrowserView.this.getBpRegionDouble());
                GBrowserView.this.redraw();
            }
        });
    }

    public RegionDouble limitRegion(RegionDouble region) {
        long maxBp = -1L;
        boolean isEndLimited = false;
        if (this.viewLimiter != null && this.viewLimiter.getLimit() != null) {
            BpCoord limit = this.viewLimiter.getLimit();
            if (limit.chr.equals(region.start.chr)) {
                maxBp = this.getMaxBp(limit.bp);
            }
        }
        if (maxBp == -1L) {
            maxBp = (long)region.end.bp.doubleValue();
        }
        RegionDouble limitedRegion = region.clone();
        if (limitedRegion.end.bp > (double)maxBp) {
            limitedRegion.move((double)maxBp - limitedRegion.end.bp);
            isEndLimited = true;
        }
        long minBp = this.getMinBp((long)Math.min((double)maxBp, region.end.bp));
        if (limitedRegion.start.bp < (double)minBp) {
            if (isEndLimited) {
                limitedRegion.start.bp = minBp;
            } else {
                limitedRegion.move((double)minBp - limitedRegion.start.bp);
            }
        }
        return limitedRegion;
    }

    public ViewLimiter getViewLimiter() {
        return this.viewLimiter;
    }

    @Override
    public void setHeight(int height) {
        this.layoutHeight = height;
    }

    @Override
    public int getMinHeight() {
        return LayoutTool.getMinHeightSum(this);
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    public void addScrollGroup(ScrollGroup group) {
        this.scrollGroups.add(group);
    }

    public Collection<? extends ScrollGroup> getScrollGroups() {
        return this.scrollGroups;
    }

    @Override
    public Collection<? extends LayoutComponent> getLayoutComponents() {
        return this.getScrollGroups();
    }
}

