/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation;

import fi.csc.microarray.client.operation.ExecutionItem;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.description.SADLSyntax;
import fi.csc.microarray.exception.MicroarrayException;
import java.awt.Color;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class Operation
implements ExecutionItem {
    private static final Logger logger = Logger.getLogger(Operation.class);
    private OperationDefinition definition;
    private LinkedList<DataBinding> bindings = new LinkedList();
    private LinkedList<Parameter> parameters;
    private ResultListener resultListener;
    private DataFolder outputFolder;

    public Operation(OperationDefinition definition, DataBean[] beans) throws MicroarrayException {
        logger.debug((Object)("created operation from definition " + definition.getID()));
        this.definition = definition;
        this.parameters = Parameter.cloneParameters(definition.getParameters());
        this.bindInputs(beans);
    }

    public Operation(Operation o) throws MicroarrayException {
        logger.debug((Object)("cloned operation from " + o.getID()));
        this.definition = o.definition;
        this.bindings = o.bindings != null ? o.bindings : new LinkedList();
        this.parameters = Parameter.cloneParameters(o.getParameters());
    }

    public OperationDefinition getDefinition() {
        return this.definition;
    }

    public LinkedList<Parameter> getParameters() {
        return this.parameters;
    }

    public void bindInputs(DataBean[] beans) throws MicroarrayException {
        this.bindings = this.definition.bindInputs(Arrays.asList(beans));
        if (this.bindings == null) {
            this.bindings = new LinkedList();
        }
        for (Parameter parameter : this.parameters) {
            if (this.bindings == null) {
                parameter.setDataBindings(new LinkedList<DataBinding>());
                continue;
            }
            parameter.setDataBindings(this.bindings);
        }
    }

    public void clearBindings() {
        this.bindings.clear();
    }

    public List<DataBinding> getBindings() {
        return this.bindings;
    }

    public DataBinding getBinding(String name) {
        for (DataBinding binding : this.bindings) {
            if (!binding.getName().equals(name)) continue;
            return binding;
        }
        return null;
    }

    public void setBindings(LinkedList<DataBinding> bindings) {
        this.bindings = bindings != null ? bindings : new LinkedList();
    }

    @Override
    public String getID() {
        return this.definition.getID();
    }

    @Override
    public String getDescription() {
        return this.definition.getDescription();
    }

    @Override
    public String getCategoryName() {
        return this.definition.getCategory().getName();
    }

    public Color getCategoryColor() {
        return this.definition.getCategory().getColor();
    }

    public String toString() {
        return this.definition.getID();
    }

    @Override
    public OperationDefinition.Suitability evaluateSuitabilityFor(Iterable<DataBean> data, OperationDefinition.Suitability currentSuitability) {
        OperationDefinition.Suitability suitability = OperationDefinition.parameterSuitability(this.getParameters());
        suitability = this.definition.evaluateSuitabilityFor(data, suitability);
        return suitability;
    }

    public void setParameter(String name, Object value) {
        this.getParameter(name).setValue(value);
    }

    public void parseParameter(String name, String stringValue) {
        this.getParameter(name).parseValue(stringValue);
    }

    public Parameter getParameter(String name) {
        for (Parameter parameter : this.parameters) {
            if (!parameter.getID().equals(name)) continue;
            return parameter;
        }
        return null;
    }

    public int getColorCount() {
        return this.definition.getColorCount();
    }

    public ResultListener getResultListener() {
        return this.resultListener;
    }

    public void setResultListener(ResultListener resultListener) {
        this.resultListener = resultListener;
    }

    public DataFolder getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(DataFolder outputFolder) {
        this.outputFolder = outputFolder;
    }

    @Override
    public String getDisplayName() {
        return this.definition.getDisplayName();
    }

    public static interface ResultListener {
        public void resultData(Iterable<DataBean> var1);

        public void noResults();
    }

    public static class DataBinding {
        private DataBean data;
        private String name;
        private SADLSyntax.InputType inputType;

        public DataBinding(DataBean data, String name, SADLSyntax.InputType inputType) {
            this.data = data;
            this.name = name;
            this.inputType = inputType;
        }

        public DataBean getData() {
            return this.data;
        }

        public String getName() {
            return this.name;
        }

        public SADLSyntax.InputType getInputType() {
            return this.inputType;
        }
    }
}

