/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.web.adminweb.ui;

import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.server.ThemeResource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.ProgressIndicator;
import com.vaadin.ui.VerticalLayout;
import fi.csc.chipster.web.adminweb.ChipsterAdminUI;
import fi.csc.chipster.web.adminweb.data.ServiceContainer;
import fi.csc.chipster.web.adminweb.data.ServiceEntry;
import fi.csc.chipster.web.adminweb.ui.ServicesTable;
import fi.csc.microarray.messaging.AdminAPI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;

public class ServicesView
extends VerticalLayout
implements Button.ClickListener,
Property.ValueChangeListener {
    private ServicesTable table;
    private HorizontalLayout toolbarLayout;
    private Button refreshButton = new Button("Refresh");
    private ServiceContainer dataSource;
    private ChipsterAdminUI app;
    private ProgressIndicator progressIndicator = new ProgressIndicator(0.0f);
    private boolean updateDone;
    private static final int POLLING_INTERVAL = 100;

    public ServicesView(ChipsterAdminUI app) {
        this.app = app;
        this.addComponent((Component)this.getToolbar());
        this.progressIndicator.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.addComponent((Component)this.progressIndicator);
        this.table = new ServicesTable(this);
        this.addComponent((Component)this.table);
        this.setExpandRatio((Component)this.table, 1.0f);
        this.setSizeFull();
        try {
            this.dataSource = new ServiceContainer();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.table.setContainerDataSource((Container)this.dataSource);
        this.table.setVisibleColumns(ServiceContainer.NATURAL_COL_ORDER);
        this.table.setColumnHeaders(ServiceContainer.COL_HEADERS_ENGLISH);
        this.table.setSortContainerPropertyId("name");
    }

    public HorizontalLayout getToolbar() {
        if (this.toolbarLayout == null) {
            this.toolbarLayout = new HorizontalLayout();
            this.refreshButton.setIcon((Resource)new ThemeResource("../runo/icons/32/reload.png"));
            this.refreshButton.addClickListener((Button.ClickListener)this);
            this.toolbarLayout.addComponent((Component)this.refreshButton);
            Label spaceEater = new Label(" ");
            this.toolbarLayout.addComponent((Component)spaceEater);
            this.toolbarLayout.setExpandRatio((Component)spaceEater, 1.0f);
            this.toolbarLayout.addComponent(this.app.getTitle());
            this.toolbarLayout.setWidth("100%");
            this.toolbarLayout.setStyleName("toolbar");
        }
        return this.toolbarLayout;
    }

    public void buttonClick(Button.ClickEvent event) {
        Button source = event.getButton();
        if (source == this.refreshButton) {
            this.update();
        }
    }

    public void update() {
        this.refreshButton.setEnabled(false);
        this.updateDone = false;
        this.dataSource.update(this);
        this.progressIndicator.setPollingInterval(100);
        ExecutorService execService = Executors.newCachedThreadPool();
        execService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int DELAY = 300;
                    for (int i = 0; i <= 300; ++i) {
                        if (ServicesView.this.updateDone) {
                            break;
                        }
                        if (ServicesView.this.progressIndicator.getUI() != null) {
                            Lock indicatorLock = ServicesView.this.progressIndicator.getUI().getSession().getLockInstance();
                            indicatorLock.lock();
                            try {
                                ServicesView.this.progressIndicator.setValue(Float.valueOf((float)i / 300.0f));
                            }
                            finally {
                                indicatorLock.unlock();
                            }
                        }
                        try {
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                finally {
                    ServicesView.this.refreshButton.setEnabled(true);
                    if (ServicesView.this.progressIndicator.getUI() != null) {
                        Lock indicatorLock = ServicesView.this.progressIndicator.getUI().getSession().getLockInstance();
                        indicatorLock.lock();
                        try {
                            ServicesView.this.progressIndicator.setValue(Float.valueOf(1.0f));
                            ServicesView.this.progressIndicator.setPollingInterval(Integer.MAX_VALUE);
                        }
                        finally {
                            indicatorLock.unlock();
                        }
                    }
                }
            }
        });
    }

    public void valueChange(Property.ValueChangeEvent event) {
        Property property = event.getProperty();
        if (property == this.table) {
            // empty if block
        }
    }

    public ChipsterAdminUI getApp() {
        return this.app;
    }

    public ServicesTable getTable() {
        return this.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDone() {
        if (this.table.getUI() != null) {
            Lock tableLock = this.table.getUI().getSession().getLockInstance();
            tableLock.lock();
            try {
                for (ServiceEntry entry : this.dataSource.getItemIds()) {
                    if (!AdminAPI.NodeStatus.Status.UNKNOWN.equals((Object)entry.getStatus())) continue;
                    entry.setStatus(AdminAPI.NodeStatus.Status.DOWN);
                }
                this.table.markAsDirtyRecursive();
            }
            finally {
                tableLock.unlock();
            }
        }
        this.updateDone = true;
    }
}

