
package org.jfree.chart.plot.junit;

import java.util.*;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;

import javax.swing.event.*;
import javax.swing.*;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.jfree.chart.plot.GradientColorPalette;



/**
 * Tests for the {@link GradientColorPalette} class.
 */
public class GradientColorPaletteTests extends TestCase 
					implements ChangeListener{

    private ChangeEvent e;

    private GradientColorPalette defaultPalette;
    /**
     * Returns the tests as a test suite.
     *
     * @return The test suite.
     */
    public static Test suite() {
        return new TestSuite(GradientColorPaletteTests.class);
    }

    /**
     * Constructs a new set of tests.
     *
     * @param name  the name of the tests.
     */
    public GradientColorPaletteTests(String name) {
        super(name);
        this.defaultPalette = new GradientColorPalette();
        
    }

    /**
     * Test the equals() method.
     */
    public void testEquals() {
        
        GradientColorPalette palette1 = new GradientColorPalette();
        GradientColorPalette palette2 = new GradientColorPalette();
        assertTrue(palette1.equals(palette2));
        assertTrue(palette2.equals(palette1));
        
        palette1.addKeyColor(15, new Color(255,127,0));
        assertFalse(palette1.equals(palette2));
        assertFalse(palette2.equals(palette1));

        GradientColorPalette palette3 = new GradientColorPalette();
        GradientColorPalette palette4 = new GradientColorPalette();

	assertTrue(palette3.equals(palette4));
	palette3.setKeyColor(1.0, Color.RED);

	assertFalse(palette3.equals(palette4));
    }

    /**
     * Some basic checks for the clone() method.
     */
    public void testCloning() {
        GradientColorPalette p1 = new GradientColorPalette();
        GradientColorPalette p2 = null;

	p1.addChangeListener(this);
	p1.addChangeListener(this);

	p2 = (GradientColorPalette) p1.clone();
        assertTrue(p1 != p2);
        assertTrue(p1.getClass() == p2.getClass());
        assertTrue(p1.equals(p2));

	
    }

    /**
     * Checks for add/removeKeyColor() methods.
     */
    public void testAddSetRemoveKeyColor() {

	// four methods to test here
	// addKeyColor()
	// addKeyColor()
	// setKeyColor()
	// removeKeyColor()

	// we create a standard -1=red, 0=black, 1=green palette.
        GradientColorPalette p1 = new GradientColorPalette();
	
	Color clr = new Color(1,2,3);

	// real addition of key color
	p1.addKeyColor(2.0,1,2,3);
	assertTrue(p1.getKeyColor(2.0).equals(clr));
	p1.addKeyColor(3.0,clr);
	assertTrue(p1.getKeyColor(3.0).equals(clr));
	
	// addition as a redifinition of a key color
	clr = new Color(5,6,7);
	p1.addKeyColor(2.0,5,6,7);
	assertTrue(p1.getKeyColor(2.0).equals(clr));
	p1.addKeyColor(3.0,clr);
	assertTrue(p1.getKeyColor(3.0).equals(clr));

	// min and max
        p1.addKeyColor(Double.MIN_VALUE, 0, 0, 0);
	p1.addKeyColor(Double.MAX_VALUE, 255, 255, 255);

	// null add
	try {
	    p1.addKeyColor(0.0, null);
	    assertTrue(false);
	} catch (NullPointerException e) {
	    ;
	}

	// the six possible versions of min-1 and max+1 in add.
	try {
	    p1.addKeyColor(Double.MIN_VALUE, -1, 0, 0);
	    assertTrue(false);
	} catch (IllegalArgumentException e) {
	    ;
	}
	try {
	    p1.addKeyColor(Double.MIN_VALUE, 0, -1, 0);
	    assertTrue(false);
	} catch (IllegalArgumentException e) {
	    ;
	}
	try {
	    p1.addKeyColor(Double.MIN_VALUE, 0, 0, -1);
	    assertTrue(false);
	} catch (IllegalArgumentException e) {
	    ;
	}
	try {
	    p1.addKeyColor(Double.MAX_VALUE, 256, 255, 255);
	    assertTrue(false);
	} catch (IllegalArgumentException e) {
	    ;
	}
	try {
	    p1.addKeyColor(Double.MAX_VALUE, 255, 256, 255);
	    assertTrue(false);
	} catch (IllegalArgumentException e) {
	    ;
	}
	try {
	    p1.addKeyColor(Double.MAX_VALUE, 255, 255, 256);
	    assertTrue(false);
	} catch (IllegalArgumentException e) {
	    ;
	}

	// addition as a redifinition of a key color
	clr = new Color(5,6,7);
	p1.addKeyColor(2.0,5,6,7);
	assertTrue(p1.getKeyColor(2.0).equals(clr));
	p1.addKeyColor(3.0,clr);
	assertTrue(p1.getKeyColor(3.0).equals(clr));

	// set
	clr = new Color(7,8,9);
	p1.setKeyColor(3.0,clr);
	assertTrue(p1.getKeyColor(3.0).equals(clr));
	try {
	    p1.setKeyColor(Double.MAX_VALUE, null);
	    assertTrue(false);
	} catch (NullPointerException e) {
	    ;
	}

	// working remove of a key.
	Color clrTemp = p1.removeKeyColor(2.0);
	clrTemp = p1.getKeyColor(2.0);
	assertTrue(clrTemp == null);

	// invalid remove of a key.
	clrTemp = p1.removeKeyColor(2.0);
	assertTrue(clrTemp == null);
	
    }

    /**
     * Checks for getColor() method.
     */
    public void testGetColor(){
        
	GradientColorPalette p1 = new GradientColorPalette();
	GradientColorPalette p2 = new GradientColorPalette();
       	GradientColorPalette p3 = new GradientColorPalette();
        GradientColorPalette p4 = new GradientColorPalette();

	
	// palette1
	p1.setLinear(false);

	p1.removeKeyColor(1.0);
	p1.removeKeyColor(0.0);

	p1.addKeyColor(-0.4, Color.red);

	Color color = p1.getColor(-0.9);
	
	p1.addKeyColor(0.5, 1, 2, 3);
	
	assertEquals(p1.getColor(0.5), new Color(1, 2, 3));
	
	try {
	  Color clr = p1.getColor(Double.MAX_VALUE);
	  //assertTrue(clr.equals(new Color(0, 255, 0)));
	  // this does not function correctly
	} catch (Exception e){;}

	try {
	  Color clr = p1.getColor(-Double.MAX_VALUE);
	  //assertTrue(clr.equals(new Color(255, 0, 0)));
	  // this does not function correctly
	} catch (Exception e){;}


	//palette2
	p2.setLinear(true);
	p2.getColor(0.5);


	//palette3
	p3.setLinear(false);

	p3.removeKeyColor(-1.0);
	p3.removeKeyColor(0.0);

	p3.getColor(0.6);

	
	//palette4
	p4.setLinear(false);
	Color color4 = p4.getColor(0.5);

	color4 = p4.getColor(-0.5);

    }

    /**
     * Tests the listeners.
     */
    public void testListeners(){
	
        GradientColorPalette p1 = new GradientColorPalette();
	p1.addChangeListener(this);
	p1.addChangeListener(this);

	p1.removeKeyColor(0.0);
    }

    /**
     * Test the constructor.
     */
    public void testConstructor(){

        GradientColorPalette p1 = new GradientColorPalette();

	p1 = new GradientColorPalette(new HashMap());
	assertEquals(p1.isLinear(), true);		

	try {
	  p1 = new GradientColorPalette(null);
	  assertTrue(false);
	} catch (NullPointerException e){;}

        GradientColorPalette p2 = new GradientColorPalette(Double.MIN_VALUE,Double.MAX_VALUE);

	// test with min and max switched the wrong way
	try {
	  p2 = new GradientColorPalette(Double.MAX_VALUE,Double.MIN_VALUE);
	} catch (Exception e){
	  assertTrue(false);
	}
    }


    /**
     * Implements the ChangeListener interface.
     */
    public void stateChanged(ChangeEvent e){
	this.e = e;
    }


    /**
     * Runs the test suite using JUnit's text-based runner.
     * 
     * @param args  ignored.
     */
    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }

}
