/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.manager;

import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.constants.ApplicationConstants;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.MonitoredNodeBase;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.FeedbackMessage;
import fi.csc.microarray.messaging.message.JobLogMessage;
import fi.csc.microarray.service.KeepAliveShutdownHandler;
import fi.csc.microarray.service.ShutdownCallback;
import fi.csc.microarray.util.Emails;
import fi.csc.microarray.util.MemUtil;
import it.sauronsoftware.cron4j.Scheduler;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.JMSException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.h2.tools.Server;
import org.springframework.core.io.ClassPathResource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

public class Manager
extends MonitoredNodeBase
implements MessagingListener,
ShutdownCallback {
    private final Logger logger;
    private JdbcTemplate jdbcTemplate;
    private SimpleJdbcInsert insertJobTemplate;
    private SimpleJdbcInsert insertAccountTemplate;
    private String feedbackEmail;
    private static final String CREATE_JOBS_TABLE = "CREATE TABLE IF NOT EXISTS jobs (id VARCHAR(100) PRIMARY KEY, operation VARCHAR(200), status VARCHAR(200), starttime DATETIME DEFAULT NULL, endtime DATETIME DEFAULT NULL, wallclockTime INT DEFAULT NULL, errorMessage TEXT DEFAULT NULL, outputText TEXT DEFAULT NULL, username VARCHAR(200), compHost VARCHAR(500));";
    private static final String CREATE_ACCOUNTS_TABLE = "CREATE TABLE IF NOT EXISTS accounts (username VARCHAR(200) PRIMARY KEY, ignoreInStatistics BOOLEAN DEFAULT FALSE);";
    private static final String ADMIN_ROLE = "admin_role";
    private MessagingEndpoint endpoint;

    public Manager(String configURL) throws Exception {
        boolean startAdmin;
        DirectoryLayout.initialiseServerLayout(Arrays.asList("manager"), configURL);
        Configuration configuration = DirectoryLayout.getInstance().getConfiguration();
        this.logger = Logger.getLogger(Manager.class);
        this.feedbackEmail = configuration.getString("manager", "admin-email");
        this.logger.info((Object)"starting manager...");
        String dbDriver = configuration.getString("manager", "jdbc-driver");
        String dbUrl = configuration.getString("manager", "database-url");
        boolean startWebConsole = configuration.getBoolean("manager", "start-web-console");
        String dbUsername = configuration.getString("manager", "database-username");
        String dbPassword = configuration.getString("manager", "database-password");
        int webConsolePort = configuration.getInt("manager", "web-console-port");
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setDriverClassName(dbDriver);
        dataSource.setUrl(dbUrl);
        dataSource.setUsername(dbUsername);
        dataSource.setPassword(dbPassword);
        this.jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
        this.insertJobTemplate = new SimpleJdbcInsert((DataSource)dataSource).withTableName("jobs");
        this.insertAccountTemplate = new SimpleJdbcInsert((DataSource)dataSource).withTableName("accounts");
        this.jdbcTemplate.execute(CREATE_JOBS_TABLE);
        this.jdbcTemplate.execute(CREATE_ACCOUNTS_TABLE);
        int backupInterval = configuration.getInt("manager", "backup-interval");
        String backupTimeString = configuration.getString("manager", "backup-time");
        int startHour = Integer.parseInt(backupTimeString.split(":")[0]);
        int startMinute = Integer.parseInt(backupTimeString.split(":")[1]);
        Calendar firstBackupTime = Calendar.getInstance();
        if (firstBackupTime.get(11) > startHour || firstBackupTime.get(11) == startHour && firstBackupTime.get(12) >= startMinute) {
            firstBackupTime.add(5, 1);
        }
        firstBackupTime.set(11, startHour);
        firstBackupTime.set(12, startMinute);
        firstBackupTime.set(13, 0);
        firstBackupTime.set(14, 0);
        this.logger.info((Object)("Next database backup is scheduled at " + firstBackupTime.getTime().toString()));
        Timer timer = new Timer("chipster-manager-backup", true);
        File backupDir = DirectoryLayout.getInstance().getBackupDir();
        timer.scheduleAtFixedRate((TimerTask)new BackupTimerTask(backupDir), firstBackupTime.getTime(), (long)(backupInterval * 60 * 60 * 1000));
        TimerTask additionalTask = null;
        try {
            additionalTask = (TimerTask)Class.forName("fi.csc.chipster.manager.AskareLogTimerTask").getConstructor(JdbcTemplate.class).newInstance(this.jdbcTemplate);
        }
        catch (Exception e) {
            this.logger.info((Object)"could not load additional tasks");
        }
        if (additionalTask != null) {
            Scheduler scheduler = new Scheduler();
            scheduler.schedule("10 0 * * *", additionalTask);
            scheduler.start();
        }
        this.endpoint = new MessagingEndpoint(this);
        MessagingTopic jobLogTopic = this.endpoint.createTopic(Topics.Name.JOB_LOG_TOPIC, MessagingTopic.AccessMode.READ);
        jobLogTopic.setListener(this);
        MessagingTopic feedbackTopic = this.endpoint.createTopic(Topics.Name.AUTHORISED_FEEDBACK_TOPIC, MessagingTopic.AccessMode.READ);
        feedbackTopic.setListener(this);
        if (startWebConsole) {
            Server h2WebConsoleServer = Server.createWebServer((String[])new String[]{"-webAllowOthers", "-webPort", String.valueOf(webConsolePort)});
            h2WebConsoleServer.start();
        }
        if (startAdmin = configuration.getBoolean("manager", "start-admin")) {
            String s = configuration.getString("manager", "admin-test-account-list").trim();
            if (!s.isEmpty()) {
                this.insertTestAccounts(s.split(","));
            }
            this.startAdmin(configuration);
        }
        KeepAliveShutdownHandler.init(this);
        this.logger.error((Object)("manager is up and running [" + ApplicationConstants.VERSION + "]"));
        this.logger.info((Object)("[mem: " + MemUtil.getMemInfo() + "]"));
    }

    private void insertTestAccounts(String[] accounts) {
        for (String account : accounts) {
            try {
                if (this.jdbcTemplate.queryForList("SELECT * from accounts where username like ?", (Object[])new String[]{account}).size() != 0) continue;
                this.logger.info((Object)("adding " + account + " to test accounts"));
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("username", account);
                parameters.put("ignoreInStatistics", true);
                this.insertAccountTemplate.execute(parameters);
            }
            catch (Exception e) {
                this.logger.warn((Object)("could not insert test account: " + account), (Throwable)e);
            }
        }
    }

    private void startAdmin(Configuration configuration) throws IOException, Exception {
        org.eclipse.jetty.server.Server adminServer = new org.eclipse.jetty.server.Server();
        adminServer.setThreadPool((ThreadPool)new QueuedThreadPool());
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setServer(adminServer);
        connector.setPort(configuration.getInt("manager", "admin-port"));
        adminServer.setConnectors(new Connector[]{connector});
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{ADMIN_ROLE});
        constraint.setAuthenticate(true);
        ConstraintMapping cm = new ConstraintMapping();
        cm.setConstraint(constraint);
        cm.setPathSpec("/*");
        HashLoginService loginService = new HashLoginService("Please enter Chipster Admin username and password");
        loginService.update(configuration.getString("manager", "admin-username"), (Credential)new Password(configuration.getString("manager", "admin-password")), new String[]{ADMIN_ROLE});
        ConstraintSecurityHandler sh = new ConstraintSecurityHandler();
        sh.setLoginService((LoginService)loginService);
        sh.addConstraintMapping(cm);
        WebAppContext context = new WebAppContext();
        context.setDescriptor(new ClassPathResource("WebContent/WEB-INF/web.xml").getURI().toString());
        context.setResourceBase(new ClassPathResource("WebContent").getURI().toString());
        context.setContextPath("/");
        context.setParentLoaderPriority(true);
        context.setHandler((Handler)sh);
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{context, new DefaultHandler()});
        adminServer.setHandler((Handler)handlers);
        adminServer.start();
    }

    @Override
    public String getName() {
        return "manager";
    }

    @Override
    public void onChipsterMessage(ChipsterMessage chipsterMessage) {
        if (chipsterMessage instanceof JobLogMessage) {
            JobLogMessage jobLogMessage = (JobLogMessage)chipsterMessage;
            try {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("id", jobLogMessage.getJobId());
                parameters.put("operation", jobLogMessage.getOperation());
                parameters.put("status", jobLogMessage.getState().toString());
                parameters.put("starttime", jobLogMessage.getStartTime());
                parameters.put("endtime", jobLogMessage.getEndTime());
                parameters.put("wallclockTime", (jobLogMessage.getEndTime().getTime() - jobLogMessage.getStartTime().getTime()) / 1000L);
                parameters.put("errorMessage", jobLogMessage.getErrorMessage());
                parameters.put("outputText", jobLogMessage.getOutputText());
                parameters.put("username", jobLogMessage.getUsername());
                parameters.put("compHost", jobLogMessage.getCompHost());
                this.insertJobTemplate.execute(parameters);
            }
            catch (Exception e) {
                this.logger.error((Object)"Could not insert log entry", (Throwable)e);
            }
        } else if (chipsterMessage instanceof FeedbackMessage) {
            FeedbackMessage feedback = (FeedbackMessage)chipsterMessage;
            this.logger.info((Object)("Feedback received: " + feedback.getDetails()));
            String replyEmail = !feedback.getEmail().equals("") ? feedback.getEmail() : "[not available]";
            String sessURL = !feedback.getSessionURL().equals("") ? feedback.getSessionURL() : "[not available]";
            String emailBody = feedback.getDetails() + "\n\n" + "username: " + feedback.getUsername() + "\n" + "email: " + replyEmail + "\n" + "session file: " + sessURL + "\n\n" + "Download the session file as .zip and open it in Chipster using magic shortcut SHIFT-CTRL-ALT-O\n\n";
            for (String[] log : feedback.getLogs()) {
                emailBody = emailBody + log[0] + ": " + log[1] + "\n";
            }
            Emails.sendEmail(this.feedbackEmail, !feedback.getEmail().equals("") ? feedback.getEmail() : null, "User report", emailBody);
        } else {
            this.logger.warn((Object)("Got other than JobLogMessage: " + chipsterMessage.toString()));
            return;
        }
    }

    @Override
    public void shutdown() {
        this.logger.info((Object)"shutdown requested");
        try {
            this.endpoint.close();
        }
        catch (JMSException e) {
            this.logger.error((Object)"closing messaging endpoint failed", (Throwable)e);
        }
        this.logger.info((Object)"shutting down");
    }

    private class BackupTimerTask
    extends TimerTask {
        private File baseBackupDir;

        public BackupTimerTask(File backupDir) {
            this.baseBackupDir = backupDir;
        }

        @Override
        public void run() {
            Manager.this.logger.info((Object)"Creating database backup");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd_mm:ss.SSS");
            String fileName = this.baseBackupDir.getAbsolutePath() + File.separator + "chipster-manager-db-backup-" + df.format(new Date());
            String sql = "SCRIPT TO '" + fileName + ".zip' COMPRESSION ZIP";
            Manager.this.jdbcTemplate.execute(sql);
        }
    }
}

