/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.stack;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaResultListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import javax.swing.SwingUtilities;

public abstract class SingleThreadAreaRequestHandler
extends AreaRequestHandler {
    private BlockingQueue<AreaRequest> areaRequestQueue;
    private boolean poison = false;

    public SingleThreadAreaRequestHandler(Queue<AreaRequest> areaRequestQueue, AreaResultListener areaResultListener) {
        super(areaRequestQueue, areaResultListener);
        this.areaRequestQueue = (BlockingQueue)areaRequestQueue;
        this.areaResultListener = areaResultListener;
    }

    @Override
    public void runThread() {
        this.thread = new Thread(){

            @Override
            public synchronized void run() {
                while (!SingleThreadAreaRequestHandler.this.poison) {
                    try {
                        AreaRequest areaRequest = (AreaRequest)SingleThreadAreaRequestHandler.this.areaRequestQueue.take();
                        if (areaRequest == null) continue;
                        areaRequest.getStatus().areaRequestCount = SingleThreadAreaRequestHandler.this.areaRequestQueue.size();
                        SingleThreadAreaRequestHandler.this.processAreaRequest(areaRequest);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.thread.setDaemon(true);
        this.thread.setName(this.getClass().getSimpleName());
        this.thread.start();
    }

    @Override
    protected void processAreaRequest(AreaRequest areaRequest) {
        if (areaRequest.getStatus().poison) {
            this.areaResultListener = null;
            this.poison = true;
        }
    }

    @Override
    public void createAreaResult(final AreaResult areaResult) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SingleThreadAreaRequestHandler.this.areaResultListener != null) {
                    SingleThreadAreaRequestHandler.this.areaResultListener.processAreaResult(areaResult);
                }
            }
        });
    }

    @Override
    public void setQueue(Queue<AreaRequest> queue) {
        this.areaRequestQueue = (BlockingQueue)queue;
    }
}

