/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.stack;

import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.TsvLineParser;

public class BedLineParser
extends TsvLineParser {
    private boolean convertCoordinates;

    public BedLineParser(boolean convertCoordinates) {
        this.convertCoordinates = convertCoordinates;
    }

    @Override
    public Region getRegion() {
        if (this.isContentLine()) {
            long start = this.getLong(Column.START.ordinal());
            long end = this.getLong(Column.END.ordinal());
            Chromosome chr = new Chromosome(this.getString(Column.CHROMOSOME.ordinal()));
            if (this.convertCoordinates) {
                ++start;
                ++end;
            }
            return new Region(start, end, chr);
        }
        return null;
    }

    public String getName() {
        return this.getString(Column.NAME.ordinal());
    }

    public Float getScore() {
        return this.getFloat(Column.SCORE.ordinal());
    }

    public Strand getStrand() {
        String strandString = this.getString(Column.STRAND.ordinal());
        Strand strand = null;
        if ("+".equals(strandString)) {
            strand = Strand.FORWARD;
        }
        if ("-".equals(strandString)) {
            strand = Strand.REVERSE;
        }
        return strand;
    }

    public Long getThickStart() {
        return this.getLong(Column.THICK_START.ordinal());
    }

    public Long getThickEnd() {
        return this.getLong(Column.THICK_END.ordinal());
    }

    public String getItemRgb() {
        return this.getString(Column.ITEM_RGB.ordinal());
    }

    public Long getBlockCount() {
        return this.getLong(Column.BLOCK_COUNT.ordinal());
    }

    public String getBlockStarts() {
        return this.getString(Column.BLOCK_STARTS.ordinal());
    }

    public int getColumnCount() {
        return this.values.length;
    }

    @Override
    public String getHeaderStart() {
        return "track";
    }

    public static enum Column {
        CHROMOSOME("chrom"),
        START("chromStart"),
        END("chromEnd"),
        NAME("name"),
        SCORE("score"),
        STRAND("strand"),
        THICK_START("thickStart"),
        THICK_END("thickEnd"),
        ITEM_RGB("itemRgb"),
        BLOCK_COUNT("blockCount"),
        BLOCK_SIZES("blockSizes"),
        BLOCK_STARTS("blockStarts");

        private final String name;

        private Column(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }
}

