/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaResultListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import java.util.Queue;
import javax.swing.SwingUtilities;

public abstract class AreaRequestHandler
implements Cloneable {
    private Queue<AreaRequest> areaRequestQueue;
    protected AreaResultListener areaResultListener;
    private boolean poison = false;
    protected Thread thread;

    public AreaRequestHandler(Queue<AreaRequest> areaRequestQueue, AreaResultListener areaResultListener) {
        this.areaRequestQueue = areaRequestQueue;
        this.areaResultListener = areaResultListener;
    }

    public void runThread() {
        this.thread = new Thread(){

            @Override
            public synchronized void run() {
                while (!AreaRequestHandler.this.poison) {
                    AreaRequest areaRequest = (AreaRequest)AreaRequestHandler.this.areaRequestQueue.poll();
                    if (areaRequest != null) {
                        areaRequest.getStatus().areaRequestCount = AreaRequestHandler.this.areaRequestQueue.size();
                        AreaRequestHandler.this.processAreaRequest(areaRequest);
                    }
                    boolean isWorkToDo = AreaRequestHandler.this.checkOtherQueues();
                    if (areaRequest != null || isWorkToDo) continue;
                    try {
                        AreaRequestHandler.this.thread.wait();
                    }
                    catch (InterruptedException e) {
                    }
                    catch (IllegalMonitorStateException e) {
                        e.printStackTrace();
                        AreaRequestHandler.this.poison = true;
                    }
                }
            }
        };
        this.thread.setDaemon(true);
        this.thread.setName(this.getClass().getSimpleName());
        this.thread.start();
    }

    protected boolean checkOtherQueues() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void notifyAreaRequestHandler() {
        Thread thread = this.thread;
        synchronized (thread) {
            this.thread.notifyAll();
        }
    }

    protected void processAreaRequest(AreaRequest areaRequest) {
        if (areaRequest.getStatus().poison) {
            this.areaResultListener = null;
            this.poison = true;
        }
    }

    public void createAreaResult(final AreaResult areaResult) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AreaRequestHandler.this.areaResultListener != null) {
                    AreaRequestHandler.this.areaResultListener.processAreaResult(areaResult);
                }
            }
        });
    }

    public void setAreaResultListener(AreaResultListener areaResultListener) {
        this.areaResultListener = areaResultListener;
    }

    public void setQueue(Queue<AreaRequest> queue) {
        this.areaRequestQueue = queue;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isAlive() {
        if (this.thread == null) {
            return false;
        }
        return this.thread.isAlive();
    }
}

