/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.cron4j;

import it.sauronsoftware.cron4j.InvalidPatternException;
import it.sauronsoftware.cron4j.SchedulingPattern;
import it.sauronsoftware.cron4j.ValueMatcher;
import java.util.Date;
import java.util.GregorianCalendar;

public class Predictor {
    private SchedulingPattern schedulingPattern;
    private long time;

    public Predictor(String schedulingPattern, long start) throws InvalidPatternException {
        this.schedulingPattern = new SchedulingPattern(schedulingPattern);
        this.time = start / 60000L * 1000L * 60L;
    }

    public Predictor(String schedulingPattern, Date start) throws InvalidPatternException {
        this(schedulingPattern, start.getTime());
    }

    public Predictor(String schedulingPattern) throws InvalidPatternException {
        this(schedulingPattern, System.currentTimeMillis());
    }

    public synchronized long nextMatchingTime() {
        this.time += 60000L;
        if (this.schedulingPattern.match(this.time)) {
            return this.time;
        }
        int size = this.schedulingPattern.matcherSize;
        long[] times = new long[size];
        int k = 0;
        while (k < size) {
            GregorianCalendar c = new GregorianCalendar();
            c.setTimeInMillis(this.time);
            int minute = c.get(12);
            int hour = c.get(11);
            int dayOfMonth = c.get(5);
            int month = c.get(2);
            int year = c.get(1);
            ValueMatcher minuteMatcher = (ValueMatcher)this.schedulingPattern.minuteMatchers.get(k);
            ValueMatcher hourMatcher = (ValueMatcher)this.schedulingPattern.hourMatchers.get(k);
            ValueMatcher dayOfMonthMatcher = (ValueMatcher)this.schedulingPattern.dayOfMonthMatchers.get(k);
            ValueMatcher dayOfWeekMatcher = (ValueMatcher)this.schedulingPattern.dayOfWeekMatchers.get(k);
            ValueMatcher monthMatcher = (ValueMatcher)this.schedulingPattern.monthMatchers.get(k);
            while (true) {
                if (!minuteMatcher.match(minute)) {
                    if (++minute <= 59) continue;
                    minute = 0;
                    ++hour;
                    continue;
                }
                if (hour > 23) {
                    hour = 0;
                    ++dayOfMonth;
                }
                if (!hourMatcher.match(hour)) {
                    ++hour;
                    minute = 0;
                    continue;
                }
                if (dayOfMonth > 31) {
                    dayOfMonth = 1;
                    ++month;
                }
                if (!dayOfMonthMatcher.match(dayOfMonth)) {
                    ++dayOfMonth;
                    hour = 0;
                    minute = 0;
                    continue;
                }
                if (month > 11) {
                    month = 0;
                    ++year;
                }
                if (!monthMatcher.match(month + 1)) {
                    ++month;
                    dayOfMonth = 0;
                    hour = 0;
                    minute = 0;
                    continue;
                }
                c = new GregorianCalendar();
                c.set(12, minute);
                c.set(11, hour);
                c.set(5, dayOfMonth);
                c.set(2, month);
                c.set(1, year);
                int oldDayOfMonth = dayOfMonth;
                int oldMonth = month;
                int oldYear = year;
                dayOfMonth = c.get(5);
                month = c.get(2);
                year = c.get(1);
                if (month != oldMonth || dayOfMonth != oldDayOfMonth || year != oldYear) continue;
                int dayOfWeek = c.get(7);
                if (dayOfWeekMatcher.match(dayOfWeek - 1)) break;
                hour = 0;
                minute = 0;
                if (++dayOfMonth <= 31) continue;
                dayOfMonth = 1;
                if (++month <= 11) continue;
                month = 0;
                ++year;
            }
            times[k] = c.getTimeInMillis() / 60000L * 1000L * 60L;
            ++k;
        }
        long min = Long.MAX_VALUE;
        int k2 = 0;
        while (k2 < size) {
            if (times[k2] < min) {
                min = times[k2];
            }
            ++k2;
        }
        this.time = min;
        return this.time;
    }

    public synchronized Date nextMatchingDate() {
        return new Date(this.nextMatchingTime());
    }
}

