/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.util.LinkedList;
import java.util.List;
import org.jfree.chart.plot.AbstractHCClusteringInfo;
import org.jfree.chart.plot.HCTreeNodeInfo;
import org.jfree.data.hc.DataRange;
import org.jfree.data.hc.HCTreeNode;

public class StandardHCClusteringInfo
extends AbstractHCClusteringInfo {
    private HCTreeNodeInfo root;

    public int getNumberOfVisibleItems() {
        return this.root.getVisibleDataRange().getWidth();
    }

    public StandardHCClusteringInfo(HCTreeNode rootNode, String[] names, int location) {
        if (rootNode == null) {
            throw new NullPointerException("You must create a DummyHCClusteringInfo if you do not have a root node.");
        }
        if (location != 0 && location != 1) {
            throw new IllegalArgumentException("location must be LEFT or RIGHT.");
        }
        this.location = location;
        this.names = names;
        this.listeners = new LinkedList();
        this.root = new HCTreeNodeInfo(this, rootNode);
        this.root.updateVisibleDataRange();
    }

    public HCTreeNodeInfo getRootNode() {
        return this.root;
    }

    private List generateNames(HCTreeNodeInfo node) {
        LinkedList<NameObject> list = new LinkedList<NameObject>();
        if (!node.isNodeOpen() || node.getLeftChild() == null && node.getRightChild() == null) {
            list.add(new NameObject(node));
        } else {
            if (node.getLeftChild() != null) {
                list.addAll(this.generateNames(node.getLeftChild()));
            }
            if (node.getRightChild() != null) {
                list.addAll(this.generateNames(node.getRightChild()));
            }
        }
        return list;
    }

    public List getNames() {
        return this.generateNames(this.root);
    }

    public DataRange getDataRangeForVisibleIndex(int row) {
        return this.root.getNodeByVisibleIndex(row).getNode().getDataRange();
    }

    public class NameObject
    implements Comparable {
        private HCTreeNodeInfo node;

        public NameObject(HCTreeNodeInfo node) {
            this.node = node;
        }

        public int compareTo(Object o) throws ClassCastException {
            if (o instanceof NameObject) {
                NameObject n = (NameObject)o;
                try {
                    if (n.node.getNode().getDataRange().getLeftBound() > this.node.getNode().getDataRange().getLeftBound()) {
                        return -1;
                    }
                    if (n.node.getNode().getDataRange().getLeftBound() > this.node.getNode().getDataRange().getLeftBound()) {
                        return 1;
                    }
                    return 0;
                }
                catch (Exception e) {
                    throw new ClassCastException();
                }
            }
            throw new ClassCastException();
        }

        public String toString() {
            return this.node.toString();
        }
    }
}

