/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class SeparatorTrack
extends Track {
    private Color color;
    private long maxBpLength;
    private long minBpLength;
    private int thickness;
    private String name = "separator";

    protected SeparatorTrack(long minBpLength, long maxBpLength) {
        this.minBpLength = minBpLength;
        this.maxBpLength = maxBpLength;
    }

    public SeparatorTrack(Color color, int thickness, long minBpLength, long maxBpLength) {
        this(minBpLength, maxBpLength);
        this.color = color;
        this.thickness = thickness;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        for (int i = 0; i < this.thickness; ++i) {
            drawables.add(new LineDrawable(0, i, this.getView().getWidth(), i, this.color));
        }
        return drawables;
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
    }

    @Override
    public int getHeight() {
        return this.thickness;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.getView().getBpRegion().getLength() > this.minBpLength && this.getView().getBpRegion().getLength() <= this.maxBpLength;
    }

    @Override
    public Map<AreaRequestHandler, Set<ColumnType>> requestedData() {
        return null;
    }
}

