/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.stack;

import fi.csc.microarray.client.visualisation.methods.gbrowser.GBrowser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Exon;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Gene;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.GeneSet;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.BinarySearchIndex;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.GtfLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.Index;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.IndexKey;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.SingleThreadAreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.UnsortedDataException;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.TreeMap;
import javax.swing.SwingUtilities;

public class GtfToFeatureConversion
extends SingleThreadAreaRequestHandler {
    private Index index;
    private GtfLineParser parser = new GtfLineParser();

    public GtfToFeatureConversion(DataSource file, final GBrowser browser) {
        super(null, null);
        try {
            this.index = new BinarySearchIndex(file, this.parser);
        }
        catch (UnsortedDataException e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    browser.showDialog("Unsorted data", e.getMessage(), null, true, false, true, true);
                }
            });
            this.index = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (GBrowserException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void processAreaRequest(AreaRequest request) {
        super.processAreaRequest(request);
        if (request.getStatus().poison) {
            return;
        }
        if (this.index == null) {
            return;
        }
        long start = request.start.bp;
        long end = request.end.bp;
        int EXTRA = 500000;
        start = Math.max(start - (long)EXTRA, 1L);
        Region requestRegion = new Region(start, end += (long)EXTRA, request.start.chr);
        TreeMap<IndexKey, String> lines = null;
        try {
            lines = this.index.getFileLines(new AreaRequest(requestRegion, request.getRequestedContents(), request.getStatus()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (GBrowserException e) {
            e.printStackTrace();
        }
        GeneSet geneSet = new GeneSet();
        for (String line : lines.values()) {
            this.parser.setLine(line);
            Region region = this.parser.getRegion();
            String feature = this.parser.getFeature();
            String geneId = this.parser.getGeneId();
            String transcId = this.parser.getTranscriptId();
            String exonString = this.parser.getAttribute("exon_number");
            int exonNumber = -1;
            if (exonString != null) {
                exonNumber = new Integer(exonString);
            }
            String transcName = this.parser.getAttribute("gene_name");
            String geneName = this.parser.getAttribute("transcript_name");
            String biotype = null;
            Exon exon = new Exon(region, feature, exonNumber);
            geneSet.addExon(exon, geneId, transcId, geneName, transcName, biotype);
        }
        LinkedList<RegionContent> list = new LinkedList<RegionContent>();
        for (Gene gene : geneSet.values()) {
            LinkedHashMap<ColumnType, Object> valueMap = new LinkedHashMap<ColumnType, Object>();
            valueMap.put(ColumnType.VALUE, gene);
            RegionContent regionContent = new RegionContent(gene.getRegion(), valueMap);
            list.add(regionContent);
        }
        super.createAreaResult(new AreaResult(request.getStatus(), list));
    }
}

