/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dialog;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.client.dialog.DialogInfo;
import fi.csc.microarray.client.dialog.FeedbackDialog;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class ChipsterDialog
extends JDialog {
    private static final int DETAILS_AREA_HEIGHT = 200;
    private static final int DETAIL_AREA_WIDTH = 400;
    private JPanel detailsPanel = new JPanel();
    private SwingClientApplication application;
    private DetailsVisibility detailsVisibility;
    private DialogCloseListener dialogCloseListener;
    private PluginButton pluginButton;

    public ChipsterDialog(SwingClientApplication app, DialogInfo dialogInfo, DetailsVisibility detailsVisibility, PluginButton pluginButton) {
        super(app != null ? app.getMainFrame() : null);
        this.application = app;
        this.detailsVisibility = detailsVisibility;
        this.pluginButton = pluginButton;
        SwingClientApplication.setPlastic3DLookAndFeel(this);
        JPanel mainPanel = this.getMainPanel(dialogInfo);
        mainPanel.setBorder(new EmptyBorder(10, 10, 0, 0));
        this.getContentPane().add(mainPanel);
        this.setLocationByPlatform(true);
        this.pack();
    }

    private JPanel getMainPanel(DialogInfo dialogInfo) {
        Icon icon2;
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints g = new GridBagConstraints();
        g.anchor = 18;
        g.gridx = 0;
        g.gridy = 0;
        g.weightx = 0.0;
        g.insets = new Insets(5, 0, 10, 5);
        switch (dialogInfo.getSeverity()) {
            case INFO: {
                icon2 = UIManager.getLookAndFeelDefaults().getIcon("OptionPane.informationIcon");
                break;
            }
            case WARNING: {
                icon2 = UIManager.getLookAndFeelDefaults().getIcon("OptionPane.warningIcon");
                break;
            }
            case ERROR: {
                icon2 = UIManager.getLookAndFeelDefaults().getIcon("OptionPane.errorIcon");
                break;
            }
            case QUESTION: {
                Icon icon2 = UIManager.getLookAndFeelDefaults().getIcon("OptionPane.questionIcon");
            }
            default: {
                throw new IllegalArgumentException("unsupported severity level: " + (Object)((Object)dialogInfo.getSeverity()));
            }
        }
        mainPanel.add((Component)new JLabel(icon2), g);
        ++g.gridx;
        g.weightx = 1.0;
        g.gridwidth = 4;
        JTextArea titleArea = new JTextArea(dialogInfo.getTitle());
        titleArea.setEditable(false);
        titleArea.setLineWrap(true);
        titleArea.setWrapStyleWord(true);
        titleArea.setFont(titleArea.getFont().deriveFont(1, 13.0f));
        titleArea.setColumns(32);
        titleArea.setBackground(mainPanel.getBackground());
        JTextArea messageArea = new JTextArea(dialogInfo.getMessage());
        messageArea.setEditable(false);
        messageArea.setLineWrap(true);
        messageArea.setWrapStyleWord(true);
        messageArea.setColumns(38);
        messageArea.setBackground(mainPanel.getBackground());
        mainPanel.add((Component)titleArea, g);
        ++g.gridy;
        mainPanel.add((Component)messageArea, g);
        ++g.gridy;
        g.gridwidth = 1;
        g.gridx = 1;
        g.weightx = 0.0;
        g.insets = new Insets(5, 0, 0, 5);
        if (this.detailsVisibility == DetailsVisibility.DETAILS_VISIBLE || this.detailsVisibility == DetailsVisibility.DETAILS_HIDDEN) {
            mainPanel.add((Component)this.getDetailsButton(), g);
        }
        ++g.gridx;
        if (dialogInfo.getFeedbackVisible().booleanValue()) {
            JButton feedbackButton = new JButton("Contact Support...");
            final String errorMessage = dialogInfo.getDetails();
            feedbackButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FeedbackDialog feedback = new FeedbackDialog(ChipsterDialog.this.application, errorMessage);
                    feedback.showDialog();
                }
            });
            feedbackButton.setEnabled(!Session.getSession().getServiceAccessor().isStandalone());
            mainPanel.add((Component)feedbackButton, g);
        }
        ++g.gridx;
        if (dialogInfo.getType() == DialogInfo.Type.OPTION) {
            g.anchor = 13;
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChipsterDialog.this.dispose();
                    if (ChipsterDialog.this.dialogCloseListener != null) {
                        ChipsterDialog.this.dialogCloseListener.dialogClosed(false);
                    }
                }
            });
            mainPanel.add((Component)cancelButton, g);
            g.anchor = 17;
        }
        ++g.gridx;
        if (this.pluginButton != null) {
            JButton button = new JButton(this.pluginButton.getText());
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChipsterDialog.this.close();
                    ChipsterDialog.this.pluginButton.actionPerformed();
                }
            });
            mainPanel.add((Component)button, g);
        }
        ++g.gridx;
        String okButtonContent = dialogInfo.getType().getButtonText();
        if (okButtonContent != null) {
            JButton okButton = new JButton(dialogInfo.getType().getButtonText());
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChipsterDialog.this.close();
                }
            });
            mainPanel.add((Component)okButton, g);
        }
        ++g.gridy;
        g.gridx = 1;
        g.fill = 1;
        g.gridwidth = 5;
        g.weighty = 1.0;
        CardLayout detailsCardLayout = new CardLayout();
        this.detailsPanel.setLayout(detailsCardLayout);
        JTextArea detailsArea = new JTextArea(dialogInfo.getDetails());
        detailsArea.setBorder(new LineBorder(Color.BLACK));
        detailsArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(detailsArea);
        this.detailsPanel.add((Component)scrollPane, "visible");
        JPanel placeholder = new JPanel();
        this.detailsPanel.add((Component)placeholder, "hidden");
        detailsCardLayout.show(this.detailsPanel, "hidden");
        this.detailsPanel.setPreferredSize(new Dimension(400, 0));
        mainPanel.add((Component)this.detailsPanel, g);
        return mainPanel;
    }

    private JButton getDetailsButton() {
        final JButton button = this.detailsVisibility == DetailsVisibility.DETAILS_HIDDEN ? new JButton("Show details") : new JButton("Hide details");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (button.getText().equals("Show details")) {
                    ChipsterDialog.this.setDetailsVisible(true);
                    button.setText("Hide details");
                } else {
                    ChipsterDialog.this.setDetailsVisible(false);
                    button.setText("Show details");
                }
            }
        });
        return button;
    }

    public void setDetailsVisible(boolean visible) {
        CardLayout cl = (CardLayout)this.detailsPanel.getLayout();
        cl.show(this.detailsPanel, visible ? "visible" : "hidden");
        this.detailsPanel.setPreferredSize(new Dimension(400, visible ? 200 : 0));
        this.pack();
    }

    public static void showDialog(SwingClientApplication application, DialogInfo dialogInfo, DetailsVisibility detailsVisibility, boolean modal) {
        ChipsterDialog.showDialog(application, dialogInfo, detailsVisibility, modal, null, null);
    }

    public static void showDialog(SwingClientApplication application, DialogInfo dialogInfo, DetailsVisibility detailsVisibility, boolean modal, DialogCloseListener dialogCloseListener, PluginButton pluginButton) {
        ChipsterDialog dialog = new ChipsterDialog(application, dialogInfo, detailsVisibility, pluginButton);
        dialog.setDefaultCloseOperation(2);
        dialog.setModal(modal);
        dialog.setDialogCloseListener(dialogCloseListener);
        dialog.setDetailsVisible(detailsVisibility.isInitiallyVisible());
        dialog.getDetailsButton().setEnabled(detailsVisibility.isButtonEnabled());
        dialog.setVisible(true);
    }

    public void setDialogCloseListener(DialogCloseListener dialogCloseListener) {
        this.dialogCloseListener = dialogCloseListener;
    }

    private void close() {
        this.dispose();
        if (this.dialogCloseListener != null) {
            this.dialogCloseListener.dialogClosed(true);
        }
    }

    public static interface DialogCloseListener {
        public void dialogClosed(boolean var1);
    }

    public static interface PluginButton {
        public void actionPerformed();

        public String getText();
    }

    public static enum DetailsVisibility {
        DETAILS_ALWAYS_VISIBLE,
        DETAILS_ALWAYS_HIDDEN,
        DETAILS_VISIBLE,
        DETAILS_HIDDEN;


        public boolean isButtonEnabled() {
            return this == DETAILS_HIDDEN || this == DETAILS_VISIBLE;
        }

        public boolean isInitiallyVisible() {
            return this == DETAILS_ALWAYS_VISIBLE || this == DETAILS_VISIBLE;
        }
    }
}

