/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.readers;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.broad.tribble.readers.PositionalBufferedStream;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PositionalBufferedStreamTest {
    InputStream FileIs;
    long expectedBytes;

    @BeforeMethod
    public void setUp() throws Exception {
        File fi = new File("test/data/test.bed");
        this.FileIs = new FileInputStream(fi);
        this.expectedBytes = fi.length();
    }

    @AfterMethod
    public void tearDown() throws Exception {
        if (this.FileIs != null) {
            this.FileIs.close();
            this.FileIs = null;
        }
    }

    @Test
    public void testPeek() throws Exception {
        int trials = 10;
        PositionalBufferedStream is = new PositionalBufferedStream(this.FileIs);
        int bb = is.peek();
        int ii = 0;
        while (ii < trials) {
            AssertJUnit.assertEquals((int)bb, (int)is.peek());
            AssertJUnit.assertEquals((long)0L, (long)is.getPosition());
            ++ii;
        }
        while ((bb = is.peek()) >= 0) {
            AssertJUnit.assertEquals((int)is.read(), (int)bb);
        }
    }

    @Test
    public void testIsDone() throws Exception {
        PositionalBufferedStream is = new PositionalBufferedStream(this.FileIs);
        while (!is.isDone()) {
            is.read();
        }
        AssertJUnit.assertTrue((boolean)is.isDone());
        AssertJUnit.assertEquals((long)this.expectedBytes, (long)is.getPosition());
    }

    @Test
    public void testReadCorrectNumberBytes() throws Exception {
        int[] bufSizes;
        int[] nArray = bufSizes = new int[]{5, 20, 60, 120, 131, 150, 200, 1000, 10000, 20000, 512000, 0x200000};
        int n = bufSizes.length;
        int n2 = 0;
        while (n2 < n) {
            Integer bufSize = nArray[n2];
            this.setUp();
            this.tstReadCorrectNumberBytes(bufSize);
            this.tearDown();
            ++n2;
        }
    }

    public void tstReadCorrectNumberBytes(int bufferSize) throws Exception {
        PositionalBufferedStream is = new PositionalBufferedStream(this.FileIs, bufferSize);
        long count = 0L;
        while (((InputStream)is).read() >= 0) {
            ++count;
        }
        AssertJUnit.assertEquals((long)this.expectedBytes, (long)count);
    }
}

