
package org.jfree.data.hc.junit;

import org.jfree.data.hc.DataRangeMismatchException;
import org.jfree.data.hc.NotAChildException;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * Some tests for the <code>org.jfree.data</code> package that can be run 
 * using JUnit.  You can find more information about JUnit at 
 * <a href="http://www.junit.org">http://www.junit.org</a>.
 */
public class DataHCPackageTests extends TestCase {

    /**
     * Returns a test suite to the JUnit test runner.
     *
     * @return The test suite.
     */
    public static Test suite() {
        TestSuite suite = new TestSuite("org.jfree.data.hc");
        suite.addTestSuite(DataRangeTests.class);
        suite.addTestSuite(HCTreeNodeTests.class);
        suite.addTestSuite(HeatMapTests.class);
        suite.addTestSuite(HCDatasetTests.class);
        suite.addTestSuite(DataHCPackageTests.class);
        return suite;
    }

    /**
     * Constructs the test suite.
     *
     * @param name  the test suite name.
     */
    public DataHCPackageTests(String name) {
        super(name);
    }
    
    /**
     * Runs the test suite using JUnit's text-based runner.
     * 
     * @param args  ignored.
     */
    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }

    public void testExceptions() {

	// just dummy tests.

	DataRangeMismatchException de;
	NotAChildException ne;

	de = new DataRangeMismatchException(null);
	de = new DataRangeMismatchException();
	ne = new NotAChildException(null);
	ne = new NotAChildException();
	assertTrue(true);

    }

}
