package org.jfree.chart.labels.junit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.jfree.data.hc.HCTreeNode;
import org.jfree.data.hc.HeatMap;
import org.jfree.chart.plot.HCTreeNodeInfo;
import org.jfree.chart.plot.StandardHCClusteringInfo;
import org.jfree.data.hc.DataRange;
import org.jfree.chart.labels.StandardHCToolTipGenerator;


/**
 * Tests for the {@link StandardHCToolTipGenerator} class.
 */
public class StandardHCToolTipGeneratorTests extends TestCase {

 
   /**
     * Returns the tests as a test suite.
     *
     * @return The test suite.
     */
    public static Test suite() {
        return new TestSuite(StandardHCToolTipGeneratorTests.class);
    }

    /**
     * Constructs a new set of tests.
     *
     * @param name  the name of the tests.
     */
    public StandardHCToolTipGeneratorTests(String name) {
        super(name);
    }


    /**
     * The tests. If the generateToolTip()-method returns anything at all, it is 
     * always the right String.
     */
    public void testGenerator(){

	StandardHCToolTipGenerator hc = new StandardHCToolTipGenerator();


	HCTreeNode node = new HCTreeNode(1.0);
	StandardHCClusteringInfo cInfo = new StandardHCClusteringInfo(node, new String[]{"names","names"}, 1);
	HCTreeNodeInfo info = new HCTreeNodeInfo(cInfo, node);

	String trial1 = hc.generateToolTip(info);
	String s1 = info.toString();

	assertTrue(trial1.equals(s1));


	HeatMap map = new HeatMap("name", 20, 20);
	DataRange rows = new DataRange(1, 10);
	DataRange columns = new DataRange(1, 10);

	String trial2 = hc.generateToolTip(map, rows, columns);

	int rowCounter;
	int columnCounter;
	int blockCount;
	double averageValue;

	for (
             averageValue = 0, blockCount = 0, rowCounter = rows.getLeftBound();
             rowCounter <= rows.getRightBound();
             rowCounter++){
             for (columnCounter = columns.getLeftBound();columnCounter <= columns.getRightBound(); columnCounter++, blockCount++) {
                 averageValue += map.get(rowCounter,columnCounter);
             }
        }

        averageValue = averageValue/blockCount;

	String s2 =  "(" + rows.getLeftBound() + "," + columns.getLeftBound() + ") .. "
             + "(" + rows.getRightBound() + "," + columns.getRightBound() + ") = "
             + averageValue + " (contains " + blockCount + " blocks)";
	
	assertTrue(trial2.equals(s2));



	DataRange minus = new DataRange(1, 0);
	DataRange minus2 = new DataRange(1, 0);

	String trial3 = hc.generateToolTip(map, minus, minus2);
	String s3 = "This block contains no data.";

	assertTrue(trial3.equals(s3));
	

	DataRange noRows = new DataRange(1, 1);
	DataRange noColumns = new DataRange(1, 1);

	String trial4 = hc.generateToolTip(map, noRows, noColumns);
	String s4 = "(" + noRows.getLeftBound() + "," + noColumns.getLeftBound() + ") = "
                 + map.get(noRows.getLeftBound(),noColumns.getLeftBound());

	assertTrue(trial4.equals(s4));

    }

    /**
     * Tests for error recovery.
     */
    public void testWrong(){

	StandardHCToolTipGenerator hc = new StandardHCToolTipGenerator();

	HCTreeNode node = new HCTreeNode(1.0);
	StandardHCClusteringInfo cInfo = new StandardHCClusteringInfo(node, new String[]{"names","names"}, 1);
	HCTreeNodeInfo info = new HCTreeNodeInfo(cInfo, node);

	HeatMap map = new HeatMap("name", 20, 20);
	DataRange rows = new DataRange(1, 10);
	DataRange columns = new DataRange(1, 10);
	
	// try null values
	try {
	  hc.generateToolTip(null, rows, columns);
	  assertTrue(true);
	} catch (Exception e){;}

	try {
	  hc.generateToolTip(map, null, columns);
	  assertTrue(true);
	} catch (Exception e){;}

	try {
	  hc.generateToolTip(map, rows, null);
	  assertTrue(true);
	} catch (Exception e){;}


    }
}
