/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.hc;

import org.jfree.data.hc.DataRangeMismatchException;

public class DataRange
implements Cloneable {
    private int leftBound;
    private int rightBound;

    public DataRange(int leftBound, int rightBound) {
        if (rightBound < leftBound) {
            this.leftBound = Integer.MAX_VALUE;
            this.rightBound = Integer.MIN_VALUE;
        } else {
            this.leftBound = leftBound;
            this.rightBound = rightBound;
        }
    }

    public boolean isEmpty() {
        return this.rightBound < this.leftBound;
    }

    public int getLeftBound() {
        if (this.isEmpty()) {
            throw new RuntimeException("getLeftBound() was called on an empty DataRange.");
        }
        return this.leftBound;
    }

    public int getRightBound() {
        if (this.isEmpty()) {
            throw new RuntimeException("getRightBound() was called on an empty DataRange.");
        }
        return this.rightBound;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        return "[" + this.leftBound + "," + this.rightBound + "]";
    }

    public int getWidth() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.rightBound - this.leftBound + 1;
    }

    public boolean contains(DataRange that) {
        if (that.isEmpty()) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        if (that.getLeftBound() < this.leftBound) {
            return false;
        }
        return that.getRightBound() <= this.rightBound;
    }

    public boolean contains(int index) {
        if (this.isEmpty()) {
            return false;
        }
        if (index < this.leftBound) {
            return false;
        }
        return index <= this.rightBound;
    }

    public void add(DataRange range) throws DataRangeMismatchException {
        int newRight;
        int newLeft;
        try {
            newLeft = range.getLeftBound();
            newRight = range.getRightBound();
        }
        catch (Exception e) {
            return;
        }
        if (this.isEmpty()) {
            this.leftBound = newLeft;
            this.rightBound = newRight;
        } else {
            if (newLeft < this.leftBound) {
                if (newRight < this.leftBound - 1) {
                    throw new DataRangeMismatchException();
                }
                this.leftBound = newLeft;
            }
            if (newRight > this.rightBound) {
                if (newLeft > this.rightBound + 1) {
                    throw new DataRangeMismatchException();
                }
                this.rightBound = newRight;
            }
        }
    }

    public Object clone() {
        return new DataRange(this.leftBound, this.rightBound);
    }

    public boolean equals(DataRange range) {
        if (this.isEmpty() && range.isEmpty()) {
            return true;
        }
        if (this.isEmpty() != range.isEmpty()) {
            return false;
        }
        if (range.getLeftBound() != this.getLeftBound()) {
            return false;
        }
        return range.getRightBound() == this.getRightBound();
    }
}

