/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.handlers;

import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipFile;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.handlers.DataBeanHandlerBase;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ZipDataBeanHandler
extends DataBeanHandlerBase {
    private static final Logger logger = Logger.getLogger(ZipDataBeanHandler.class);
    private Map<File, ZipFile> zipFileInstances = new HashMap<File, ZipFile>();

    public ZipDataBeanHandler(DataManager dataManager) {
        super(dataManager, DataBean.StorageMethod.LOCAL_SESSION);
    }

    @Override
    public long getContentLength(DataBean dataBean) throws IOException {
        this.checkCompatibility(dataBean);
        ZipFile zipFile = this.createZipFile(dataBean);
        ZipEntry zipEntry = zipFile.getEntry(dataBean.getContentUrl().getRef());
        return zipEntry.getSize();
    }

    @Override
    public InputStream getInputStream(DataBean dataBean) throws IOException {
        this.checkCompatibility(dataBean);
        ZipFile zipFile = this.createZipFile(dataBean);
        ZipEntry zipEntry = zipFile.getEntry(dataBean.getContentUrl().getRef());
        return zipFile.getInputStream(zipEntry);
    }

    private ZipFile createZipFile(DataBean dataBean) throws IOException {
        File file = this.getZipFile(dataBean);
        if (!this.zipFileInstances.containsKey(file)) {
            this.zipFileInstances.put(file, new ZipFile(file));
        }
        return this.zipFileInstances.get(file);
    }

    public void closeZipFiles() {
        for (ZipFile zipFile : this.zipFileInstances.values()) {
            try {
                zipFile.close();
            }
            catch (Exception e) {
                logger.warn((Object)"could not close zip file");
            }
        }
        this.zipFileInstances.clear();
    }

    @Override
    protected void checkCompatibility(DataBean dataBean) throws IllegalArgumentException {
        super.checkCompatibility(dataBean);
        URL url = dataBean.getContentUrl();
        if (url == null) {
            throw new IllegalArgumentException("DataBean URL is null.");
        }
        if (!"file".equals(url.getProtocol())) {
            throw new IllegalArgumentException("Protocol of " + url.toString() + " is not \"file\".");
        }
        if (url.getPath() == null || url.getPath().length() == 0) {
            throw new IllegalArgumentException("Illegal path:" + url.toString());
        }
        if (!this.getZipFile(dataBean).getName().endsWith(".zip")) {
            throw new IllegalArgumentException("Not a session file.");
        }
        if (url.getRef() == null || url.getRef().length() == 0) {
            throw new IllegalArgumentException("Reference is null or empty.");
        }
    }

    private File getZipFile(DataBean dataBean) {
        File zipFile;
        try {
            URI beanURI = dataBean.getContentUrl().toURI();
            URI zipURI = new URI(beanURI.getScheme(), beanURI.getSchemeSpecificPart(), null);
            zipFile = new File(zipURI);
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException(dataBean.getContentUrl() + " does not point to a file.");
        }
        return zipFile;
    }

    @Override
    public void delete(DataBean dataBean) {
    }

    @Override
    public OutputStream getOutputStream(DataBean dataBean) throws IOException {
        throw new UnsupportedOperationException("zip data bean does not support output");
    }
}

