/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class PeakTrack
extends Track {
    private static final int MIN_VISIBLE_PEAK_SIZE = 5;
    private static final int PEAK_SYMBOL_HEIGHT = 10;
    private Collection<RegionContent> peaks = new TreeSet<RegionContent>();
    private long maxBpLength;
    private long minBpLength;
    private Color color;

    public PeakTrack(Color color, long minBpLength, long maxBpLength) {
        this.color = color;
        this.minBpLength = minBpLength;
        this.maxBpLength = maxBpLength;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        if (this.peaks != null) {
            Iterator<RegionContent> iter = this.peaks.iterator();
            while (iter.hasNext()) {
                RegionContent peak = iter.next();
                if (!peak.region.intersects(this.getView().getBpRegion())) {
                    iter.remove();
                    continue;
                }
                this.createDrawable(peak.region.start, peak.region.end, 10, this.color, drawables);
            }
        }
        return drawables;
    }

    private void createDrawable(BpCoord startBp, BpCoord endBp, int height, Color c, Collection<Drawable> drawables) {
        Rectangle rect = new Rectangle();
        rect.x = this.getView().bpToTrack(startBp);
        rect.width = this.getView().bpToTrack(endBp) - rect.x;
        if (rect.width < 5) {
            rect.width = 5;
        }
        rect.y = this.getHeight() / 2;
        rect.height = height;
        drawables.add(new RectDrawable(rect, c, c.darker()));
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
        this.peaks.addAll(areaResult.getContents());
        this.getView().redraw();
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.getView().getBpRegion().getLength() > this.minBpLength && this.getView().getBpRegion().getLength() <= this.maxBpLength;
    }

    @Override
    public Map<AreaRequestHandler, Set<ColumnType>> requestedData() {
        HashMap<AreaRequestHandler, Set<ColumnType>> datas = new HashMap<AreaRequestHandler, Set<ColumnType>>();
        datas.put(this.areaRequestHandler, new HashSet<ColumnType>(Arrays.asList(ColumnType.CHROMOSOME, ColumnType.BP_START, ColumnType.BP_END)));
        return datas;
    }

    @Override
    public int getHeight() {
        return 20;
    }
}

