/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.message;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoordDouble;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;

public class RegionDouble
implements Comparable<RegionDouble> {
    public BpCoordDouble start;
    public BpCoordDouble end;

    public RegionDouble(BpCoordDouble start, BpCoordDouble end) {
        this.start = start;
        this.end = end;
    }

    public RegionDouble(Double start, Double end, Chromosome chr) {
        this.start = new BpCoordDouble(start, chr);
        this.end = new BpCoordDouble(end, chr);
    }

    public RegionDouble(Double start, Chromosome chr1, Double end, Chromosome chr2) {
        this.start = new BpCoordDouble(start, chr1);
        this.end = new BpCoordDouble(end, chr2);
    }

    public RegionDouble() {
        this(null, null);
    }

    public RegionDouble(Region reg) {
        this((double)reg.start.bp, reg.start.chr, (double)reg.end.bp, reg.end.chr);
    }

    public double getLength() {
        return this.end.minus(this.start);
    }

    public double getMid() {
        return this.start.plus(this.end) / 2.0;
    }

    public String toString() {
        return "Region [" + this.start + " - " + this.end + "]";
    }

    public RegionDouble clone() {
        return new RegionDouble(this.start, this.end);
    }

    public boolean intercepts(RegionDouble other) {
        return this.end.compareTo(this.start) > 0 && this.start.compareTo(this.end) < 0;
    }

    public RegionDouble intercept(RegionDouble other) {
        return new RegionDouble(this.start.max(other.start), this.end.min(other.end));
    }

    @Override
    public int compareTo(RegionDouble o) {
        int startComparison = this.start.compareTo(this.start);
        if (startComparison != 0) {
            return startComparison;
        }
        return this.end.compareTo(o.end);
    }

    public boolean equals(Object o) {
        if (o instanceof RegionDouble) {
            RegionDouble other = (RegionDouble)o;
            return this.start.equals(other.start) && this.end.equals(other.end);
        }
        return false;
    }

    public int hashCode() {
        return this.start.hashCode();
    }

    public boolean contains(BpCoordDouble point) {
        return point.compareTo(this.start) >= 0 && point.compareTo(this.end) < 0;
    }

    public void move(double bpMove) {
        BpCoordDouble bpCoordDouble = this.start;
        bpCoordDouble.bp = bpCoordDouble.bp + bpMove;
        bpCoordDouble = this.end;
        bpCoordDouble.bp = bpCoordDouble.bp + bpMove;
    }
}

