/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.drawable;

import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackContext;
import java.awt.Color;
import java.awt.Rectangle;

public class RectDrawable
extends Drawable {
    public int width;
    public int height;
    public Color lineColor;
    private String tooltipText;

    public RectDrawable(int x, int y, int width, int height, Color fillColor, Color lineColor, String tooltipText) {
        super(x, y, fillColor);
        this.width = width;
        this.height = height;
        this.lineColor = lineColor;
        this.tooltipText = tooltipText;
    }

    @Override
    public void upsideDown() {
        super.upsideDown();
        this.y -= this.height;
    }

    public RectDrawable(int x, int y, int width, int height, Color fillColor, Color lineColor) {
        this(x, y, width, height, fillColor, lineColor, null);
    }

    public RectDrawable(Rectangle rect, Color fillColor, Color lineColor, String tooltipText) {
        this(rect.x, rect.y, rect.width, rect.height, fillColor, lineColor, tooltipText);
    }

    public RectDrawable(Rectangle rect, Color fillColor, Color lineColor) {
        this(rect.x, rect.y, rect.width, rect.height, fillColor, lineColor, null);
    }

    @Override
    public int getMaxY() {
        return this.y + this.height;
    }

    @Override
    public void expand(TrackContext context) {
        int maxY = context.trackHeight - 1;
        int newY = (int)((float)this.y * context.expansionRatio.floatValue());
        int newHeight = (int)((float)this.height * context.expansionRatio.floatValue());
        this.y = Math.min(newY, maxY);
        this.height = Math.min(newHeight, maxY - this.y);
    }

    @Override
    public String getTooltipText() {
        return this.tooltipText;
    }
}

