/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.AdvancedOptions;
import org.emboss.jemboss.gui.ScrollPanel;
import org.emboss.jemboss.gui.ShowResultSet;
import org.emboss.jemboss.gui.TabListCellRenderer;
import org.emboss.jemboss.programs.JembossProcess;
import org.emboss.jemboss.programs.ResultList;
import org.emboss.jemboss.programs.ResultsUpdateTimer;
import org.emboss.jemboss.soap.AuthPopup;
import org.emboss.jemboss.soap.JembossSoapException;
import org.emboss.jemboss.soap.PendingResults;

public class ShowSavedResults
extends JFrame {
    private Cursor cbusy = new Cursor(3);
    private Cursor cdone = new Cursor(0);
    private DefaultListModel datasets = new DefaultListModel();
    private ScrollPanel sp = new ScrollPanel();
    private JTextArea aboutRes;
    private JScrollPane aboutScroll;
    private JScrollPane ss;
    private JPanel resButtonStatus;
    private JTextField statusField;
    private JMenuBar resMenu = new JMenuBar();
    private ImageIcon rfii;

    public ShowSavedResults(String string) {
        super(string);
        this.aboutRes = new JTextArea("Select a result set from\nthose listed and details\nof that analysis will be\nshown here. Then you can\neither delete or view those\nresults using the buttons below.");
        this.aboutScroll = new JScrollPane(this.aboutRes);
        this.ss = new JScrollPane(this.sp);
        this.ss.getViewport().setBackground(Color.white);
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.rfii = new ImageIcon(classLoader.getResource("images/Refresh_button.gif"));
        this.resButtonStatus = new JPanel(new BorderLayout());
        Border border = BorderFactory.createLoweredBevelBorder();
        Border border2 = BorderFactory.createRaisedBevelBorder();
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border2, border);
        this.statusField = new JTextField();
        this.statusField.setBorder(compoundBorder);
        this.statusField.setEditable(false);
    }

    public ShowSavedResults(final JembossParams jembossParams, final JFrame jFrame) {
        this("Saved Results on Server");
        Dimension dimension = new Dimension(270, 270);
        this.ss.setPreferredSize(dimension);
        try {
            final ResultList resultList = new ResultList(jembossParams);
            JMenu jMenu = new JMenu("File");
            this.resMenu.add(jMenu);
            final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("List by program");
            jCheckBoxMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ShowSavedResults.this.listByProgramName();
                }
            });
            jMenu.add(jCheckBoxMenuItem);
            JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("List by date", true);
            jCheckBoxMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ShowSavedResults.this.listByDateRun(resultList, false);
                }
            });
            jMenu.add(jCheckBoxMenuItem2);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(jCheckBoxMenuItem);
            buttonGroup.add(jCheckBoxMenuItem2);
            JButton jButton = new JButton(this.rfii);
            jButton.setMargin(new Insets(0, 1, 0, 1));
            jButton.setToolTipText("Refresh");
            this.resMenu.add(jButton);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        ShowSavedResults.this.setCursor(ShowSavedResults.this.cbusy);
                        ResultList resultList2 = new ResultList(jembossParams);
                        ShowSavedResults.this.setCursor(ShowSavedResults.this.cdone);
                        if (resultList2.getStatus().equals("0")) {
                            resultList.updateRes(resultList2.hash());
                            ShowSavedResults.this.datasets.removeAllElements();
                            StringTokenizer stringTokenizer = new StringTokenizer((String)resultList.get("list"), "\n");
                            while (stringTokenizer.hasMoreTokens()) {
                                ShowSavedResults.this.datasets.addElement(ShowSavedResults.convertToPretty(stringTokenizer.nextToken()));
                            }
                            if (jCheckBoxMenuItem.isSelected()) {
                                ShowSavedResults.this.listByProgramName();
                            } else {
                                ShowSavedResults.this.listByDateRun(resultList, false);
                            }
                        } else {
                            JOptionPane.showMessageDialog(null, resultList2.getStatusMsg(), "Soap Error", 0);
                        }
                    }
                    catch (JembossSoapException jembossSoapException) {
                        AuthPopup authPopup = new AuthPopup(jembossParams, jFrame);
                        authPopup.setBottomPanel();
                        authPopup.setSize(380, 170);
                        authPopup.pack();
                        authPopup.setVisible(true);
                    }
                }
            });
            jMenu.addSeparator();
            JMenuItem jMenuItem = new JMenuItem("Close");
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ShowSavedResults.this.dispose();
                }
            });
            jMenu.add(jMenuItem);
            this.setJMenuBar(this.resMenu);
            this.listByDateRun(resultList, true);
            final JList jList = new JList(this.datasets);
            jList.setCellRenderer(new TabListCellRenderer());
            jList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    JList jList = (JList)listSelectionEvent.getSource();
                    if (jList.isSelectionEmpty()) {
                        System.out.println("Empty selection");
                    } else {
                        int n = jList.getSelectedIndex();
                        String string = ShowSavedResults.this.convertToOriginal(ShowSavedResults.this.datasets.elementAt(n));
                        ShowSavedResults.this.aboutRes.setText((String)resultList.get(string));
                        ShowSavedResults.this.aboutRes.setCaretPosition(0);
                    }
                }
            });
            jList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        try {
                            ShowSavedResults.this.setCursor(ShowSavedResults.this.cbusy);
                            String string = ShowSavedResults.this.convertToOriginal(jList.getSelectedValue());
                            ResultList resultList = new ResultList(jembossParams, string, "show_saved_results");
                            new ShowResultSet(resultList.hash(), string, jembossParams);
                            ShowSavedResults.this.setCursor(ShowSavedResults.this.cdone);
                        }
                        catch (JembossSoapException jembossSoapException) {
                            AuthPopup authPopup = new AuthPopup(jembossParams, jFrame);
                            authPopup.setBottomPanel();
                            authPopup.setSize(380, 170);
                            authPopup.pack();
                            authPopup.setVisible(true);
                        }
                    }
                }
            });
            this.sp.add(jList);
            JPanel jPanel = new JPanel();
            JButton jButton2 = new JButton("Display");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = ShowSavedResults.this.convertToOriginal(jList.getSelectedValue());
                    if (string != null) {
                        try {
                            ShowSavedResults.this.setCursor(ShowSavedResults.this.cbusy);
                            ResultList resultList = new ResultList(jembossParams, string, "show_saved_results");
                            new ShowResultSet(resultList.hash(), string, jembossParams);
                            ShowSavedResults.this.setCursor(ShowSavedResults.this.cdone);
                        }
                        catch (JembossSoapException jembossSoapException) {
                            AuthPopup authPopup = new AuthPopup(jembossParams, jFrame);
                            authPopup.setBottomPanel();
                            authPopup.setSize(380, 170);
                            authPopup.pack();
                            authPopup.setVisible(true);
                        }
                    } else {
                        ShowSavedResults.this.statusField.setText("Nothing selected to be displayed.");
                    }
                }
            });
            JButton jButton3 = new JButton("Edit Notes");
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = ShowSavedResults.this.convertToOriginal(jList.getSelectedValue());
                    if (string != null) {
                        try {
                            ShowSavedResults.this.setCursor(ShowSavedResults.this.cbusy);
                            ResultList resultList = new ResultList(jembossParams, string, "Notes", "show_saved_results");
                            new ShowResultSet(resultList.hash(), string, jembossParams);
                            ShowSavedResults.this.setCursor(ShowSavedResults.this.cdone);
                        }
                        catch (JembossSoapException jembossSoapException) {
                            AuthPopup authPopup = new AuthPopup(jembossParams, jFrame);
                            authPopup.setBottomPanel();
                            authPopup.setSize(380, 170);
                            authPopup.pack();
                            authPopup.setVisible(true);
                        }
                    } else {
                        ShowSavedResults.this.statusField.setText("Selected a project!");
                    }
                }
            });
            JButton jButton4 = new JButton("Delete");
            jButton4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Object[] objectArray = jList.getSelectedValues();
                    if (objectArray != null) {
                        Serializable serializable;
                        int n;
                        String string = new String("");
                        JTextPane jTextPane = new JTextPane();
                        FontMetrics fontMetrics = jTextPane.getFontMetrics(jTextPane.getFont());
                        int n2 = 0;
                        for (n = 0; n < objectArray.length; ++n) {
                            string = n == objectArray.length - 1 ? string.concat((String)objectArray[n]) : string.concat(objectArray[n] + "\n");
                            int n3 = fontMetrics.stringWidth((String)objectArray[n]);
                            if (n3 <= n2) continue;
                            n2 = n3;
                        }
                        n = 0;
                        if (objectArray.length > 1) {
                            JScrollPane jScrollPane = new JScrollPane(jTextPane);
                            jTextPane.setText(string);
                            jTextPane.setEditable(false);
                            jTextPane.setCaretPosition(0);
                            serializable = jTextPane.getPreferredSize();
                            int n4 = (int)((Dimension)serializable).getHeight() + 5;
                            if (n4 > 350) {
                                n4 = 350;
                            } else if (n4 < 50) {
                                n4 = 50;
                            }
                            jScrollPane.setPreferredSize(new Dimension(n2 + 30, n4));
                            n = JOptionPane.showConfirmDialog(null, jScrollPane, "Confirm Deletion", 0);
                        }
                        if (n == 0) {
                            try {
                                ShowSavedResults.this.setCursor(ShowSavedResults.this.cbusy);
                                string = ShowSavedResults.this.convertToOriginal(string);
                                ResultList resultList = new ResultList(jembossParams, string, "delete_saved_results");
                                ShowSavedResults.this.setCursor(ShowSavedResults.this.cdone);
                                for (int i = 0; i < objectArray.length; ++i) {
                                    ShowSavedResults.this.datasets.removeElement(objectArray[i]);
                                }
                                ShowSavedResults.this.statusField.setText("Deleted " + objectArray.length + "  result(s)");
                                ShowSavedResults.this.aboutRes.setText("");
                                jList.setSelectedIndex(-1);
                            }
                            catch (JembossSoapException jembossSoapException) {
                                serializable = new AuthPopup(jembossParams, jFrame);
                                ((AuthPopup)serializable).setBottomPanel();
                                ((Window)serializable).setSize(380, 170);
                                ((Window)serializable).pack();
                                ((Window)serializable).setVisible(true);
                            }
                        }
                    } else {
                        ShowSavedResults.this.statusField.setText("Nothing selected for deletion.");
                    }
                }
            });
            jPanel.add(jButton4);
            jPanel.add(jButton3);
            jPanel.add(jButton2);
            this.resButtonStatus.add((Component)jPanel, "Center");
            this.resButtonStatus.add((Component)this.statusField, "South");
            Container container = this.getContentPane();
            container.add((Component)this.ss, "West");
            container.add((Component)this.aboutScroll, "Center");
            container.add((Component)this.resButtonStatus, "South");
            this.pack();
            this.setVisible(true);
        }
        catch (JembossSoapException jembossSoapException) {
            AuthPopup authPopup = new AuthPopup(jembossParams, jFrame);
            authPopup.setBottomPanel();
            authPopup.setSize(380, 170);
            authPopup.pack();
            authPopup.setVisible(true);
        }
    }

    public ShowSavedResults(final JembossParams jembossParams, final PendingResults pendingResults) throws JembossSoapException {
        this("Current Sessions Results");
        Dimension dimension = new Dimension(270, 100);
        this.ss.setPreferredSize(dimension);
        JMenu jMenu = new JMenu("File");
        this.resMenu.add(jMenu);
        JButton jButton = new JButton(this.rfii);
        jButton.setMargin(new Insets(0, 1, 0, 1));
        jButton.setToolTipText("Refresh");
        this.resMenu.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShowSavedResults.this.setCursor(ShowSavedResults.this.cbusy);
                pendingResults.updateStatus();
                ShowSavedResults.this.setCursor(ShowSavedResults.this.cdone);
                ShowSavedResults.this.datasets.removeAllElements();
                Enumeration enumeration = pendingResults.descriptionHash().keys();
                while (enumeration.hasMoreElements()) {
                    String string = ShowSavedResults.convertToPretty((String)enumeration.nextElement());
                    ShowSavedResults.this.datasets.addElement(string);
                }
            }
        });
        JMenuItem jMenuItem = new JMenuItem("Close");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShowSavedResults.this.dispose();
            }
        });
        jMenu.add(jMenuItem);
        this.setJMenuBar(this.resMenu);
        Enumeration enumeration = pendingResults.descriptionHash().keys();
        while (enumeration.hasMoreElements()) {
            this.datasets.addElement(ShowSavedResults.convertToPretty((String)enumeration.nextElement()));
        }
        final JList jList = new JList(this.datasets);
        jList.setCellRenderer(new TabListCellRenderer());
        jList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                JList jList = (JList)listSelectionEvent.getSource();
                if (!jList.isSelectionEmpty()) {
                    int n = jList.getSelectedIndex();
                    String string = ShowSavedResults.this.convertToOriginal(ShowSavedResults.this.datasets.elementAt(n));
                    ShowSavedResults.this.aboutRes.setText((String)pendingResults.descriptionHash().get(string));
                    ShowSavedResults.this.aboutRes.setCaretPosition(0);
                    ShowSavedResults.this.aboutRes.setEditable(false);
                }
            }
        });
        jList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    try {
                        ShowSavedResults.this.setCursor(ShowSavedResults.this.cbusy);
                        String string = ShowSavedResults.this.convertToOriginal(jList.getSelectedValue());
                        ResultList resultList = new ResultList(jembossParams, string, "show_saved_results");
                        ShowSavedResults.this.setCursor(ShowSavedResults.this.cdone);
                        if (resultList.getStatus().equals("0")) {
                            new ShowResultSet(resultList.hash(), string, jembossParams);
                        } else {
                            JOptionPane.showMessageDialog(null, resultList.getStatusMsg(), "Soap Error", 0);
                        }
                    }
                    catch (JembossSoapException jembossSoapException) {
                        AuthPopup authPopup = new AuthPopup(jembossParams, null);
                        authPopup.setBottomPanel();
                        authPopup.setSize(380, 170);
                        authPopup.pack();
                        authPopup.setVisible(true);
                    }
                }
            }
        });
        this.sp.add(jList);
        JPanel jPanel = new JPanel();
        JButton jButton2 = new JButton("Display");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jList.getSelectedValue() != null) {
                    try {
                        ShowSavedResults.this.setCursor(ShowSavedResults.this.cbusy);
                        String string = ShowSavedResults.this.convertToOriginal(jList.getSelectedValue());
                        ResultList resultList = new ResultList(jembossParams, string, "show_saved_results");
                        ShowSavedResults.this.setCursor(ShowSavedResults.this.cdone);
                        if (resultList.getStatus().equals("0")) {
                            new ShowResultSet(resultList.hash(), string, jembossParams);
                        } else {
                            JOptionPane.showMessageDialog(null, resultList.getStatusMsg(), "Soap Error", 0);
                        }
                    }
                    catch (JembossSoapException jembossSoapException) {
                        ShowSavedResults.this.setCursor(ShowSavedResults.this.cdone);
                        AuthPopup authPopup = new AuthPopup(jembossParams, null);
                        authPopup.setBottomPanel();
                        authPopup.setSize(380, 170);
                        authPopup.pack();
                        authPopup.setVisible(true);
                    }
                }
            }
        });
        JButton jButton3 = new JButton("Delete");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = jList.getSelectedValues();
                if (objectArray != null) {
                    int n;
                    String string = new String("");
                    for (n = 0; n < objectArray.length; ++n) {
                        string = string.concat(objectArray[n] + "\n");
                    }
                    n = 0;
                    if (objectArray.length > 1) {
                        n = JOptionPane.showConfirmDialog(null, "Delete the following results:\n" + string, "Confirm Deletion", 0);
                    }
                    if (n == 0) {
                        try {
                            ShowSavedResults.this.setCursor(ShowSavedResults.this.cbusy);
                            string = ShowSavedResults.this.convertToOriginal(string);
                            ResultList resultList = new ResultList(jembossParams, string, "delete_saved_results");
                            ShowSavedResults.this.setCursor(ShowSavedResults.this.cdone);
                            for (int i = 0; i < objectArray.length; ++i) {
                                JembossProcess jembossProcess = pendingResults.getResult(ShowSavedResults.this.convertToOriginal(objectArray[i]));
                                pendingResults.removeResult(jembossProcess);
                                ShowSavedResults.this.datasets.removeElement(objectArray[i]);
                            }
                            ShowSavedResults.this.statusField.setText("Deleted " + objectArray.length + "  result(s)");
                            ShowSavedResults.this.aboutRes.setText("");
                            jList.setSelectedIndex(-1);
                        }
                        catch (JembossSoapException jembossSoapException) {
                            AuthPopup authPopup = new AuthPopup(jembossParams, null);
                            authPopup.setBottomPanel();
                            authPopup.setSize(380, 170);
                            authPopup.pack();
                            authPopup.setVisible(true);
                        }
                    }
                }
            }
        });
        jPanel.add(jButton3);
        jPanel.add(jButton2);
        this.resButtonStatus.add((Component)jPanel, "Center");
        this.resButtonStatus.add((Component)this.statusField, "South");
        Container container = this.getContentPane();
        container.add((Component)this.ss, "West");
        container.add((Component)this.aboutScroll, "Center");
        container.add((Component)this.resButtonStatus, "South");
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setVisible(true);
        String string = (String)AdvancedOptions.jobMgr.getSelectedItem();
        int n = string.indexOf(" ");
        new ResultsUpdateTimer(Integer.parseInt(string.substring(0, n)), this.datasets, this);
        this.statusField.setText("Window refresh rate " + string);
    }

    private void listByDateRun(ResultList resultList, boolean bl) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer((String)resultList.get("list"), "\n");
        Vector<Object> vector = new Vector<Object>();
        while (stringTokenizer.hasMoreTokens()) {
            object = ShowSavedResults.convertToPretty(stringTokenizer.nextToken());
            if (!this.datasets.contains(object) && !bl) continue;
            vector.add(object);
        }
        this.datasets.removeAllElements();
        object = vector.elements();
        while (object.hasMoreElements()) {
            this.datasets.addElement(object.nextElement());
        }
    }

    private void listByProgramName() {
        int n;
        int n2 = this.datasets.size();
        Object[] objectArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            objectArray[n] = (String)this.datasets.getElementAt(n);
        }
        Arrays.sort(objectArray);
        this.datasets.removeAllElements();
        for (n = 0; n < n2; ++n) {
            this.datasets.addElement(objectArray[n]);
        }
    }

    public static String convertToPretty(String string) {
        int n = string.indexOf(95);
        return string.replace('_', ' ');
    }

    private String convertToOriginal(Object object) {
        String string = ((String)object).replace('\t', '_');
        return string.replace(' ', '_');
    }
}

