/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.emboss.jemboss.editor.AlignJFrame;
import org.emboss.jemboss.editor.Matrix;
import org.emboss.jemboss.gui.filetree.FileEditorDisplay;

public class MatrixJFrame
extends JFrame {
    private JScrollPane mScroll = new JScrollPane();
    private Cursor cbusy = new Cursor(3);
    private Cursor cdone = new Cursor(0);
    private Matrix mat;

    public MatrixJFrame(Matrix matrix, final JTextField jTextField, final AlignJFrame alignJFrame) {
        this.mat = matrix;
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.mScroll, "Center");
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        jMenu.add(new JSeparator());
        JMenuItem jMenuItem = new JMenuItem("Close");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MatrixJFrame.this.setVisible(false);
            }
        });
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        Object[] objectArray = this.mat.getKeyNames();
        final JList<Object> jList = new JList<Object>(objectArray);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() < 2) {
                    return;
                }
                MatrixJFrame.this.setCursor(MatrixJFrame.this.cbusy);
                String string = (String)jList.getSelectedValue();
                MatrixJFrame.this.mat = new Matrix("resources/resources.jar", string);
                jTextField.setText("Current matrix: " + string);
                MatrixJFrame.this.setMatrix(MatrixJFrame.this.mat);
                alignJFrame.setMatrix(MatrixJFrame.this.mat);
                MatrixJFrame.this.setCursor(MatrixJFrame.this.cdone);
            }
        };
        jList.addMouseListener(mouseAdapter);
        JScrollPane jScrollPane = new JScrollPane(jList);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        JButton jButton = new JButton("Set");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MatrixJFrame.this.setCursor(MatrixJFrame.this.cbusy);
                String string = (String)jList.getSelectedValue();
                MatrixJFrame.this.mat = new Matrix("resources/resources.jar", string);
                jTextField.setText("Current matrix: " + string);
                MatrixJFrame.this.setMatrix(MatrixJFrame.this.mat);
                alignJFrame.setMatrix(MatrixJFrame.this.mat);
                MatrixJFrame.this.setCursor(MatrixJFrame.this.cdone);
            }
        });
        jPanel2.add((Component)jButton, "South");
        jPanel.add((Component)jPanel2, "East");
        this.setSize(500, 400);
    }

    public void setMatrix(Matrix matrix) {
        FileEditorDisplay fileEditorDisplay = new FileEditorDisplay("Matrix", (Object)matrix.getMatrixTable().trim());
        fileEditorDisplay.setCaretPosition(0);
        this.mScroll.setViewportView(fileEditorDisplay);
        this.setTitle(matrix.getCurrentMatrixName());
    }
}

