/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import java.io.IOException;
import java.net.URL;
import junit.framework.Assert;
import org.broad.tribble.util.SeekableFTPStream;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SeekableFTPStreamTest {
    static String urlString = "ftp://ftp.broadinstitute.org/pub/igv/TEST/test.txt";
    static long fileSize = 27L;
    static byte[] expectedBytes = "abcdefghijklmnopqrstuvwxyz\n".getBytes();
    SeekableFTPStream stream;

    @BeforeMethod
    public void setUp() throws IOException {
        this.stream = new SeekableFTPStream(new URL(urlString));
    }

    @AfterMethod
    public void tearDown() throws IOException {
        this.stream.close();
    }

    @Test
    public void testLength() throws Exception {
        long length = this.stream.length();
        Assert.assertEquals((long)fileSize, (long)length);
    }

    @Test
    public void testBufferedRead() throws Exception {
        byte[] buffer = new byte[64000];
        int nRead = this.stream.read(buffer);
        Assert.assertEquals((long)fileSize, (long)nRead);
    }

    @Test
    public void testRange() throws Exception {
        this.stream.seek(20L);
        byte[] buffer = new byte[64000];
        int nRead = this.stream.read(buffer);
        Assert.assertEquals((long)(fileSize - 20L), (long)nRead);
    }

    @Test
    public void testBadRange() throws Exception {
        this.stream.seek(30L);
        byte[] buffer = new byte[64000];
        int nRead = this.stream.read(buffer);
        Assert.assertEquals((int)-1, (int)nRead);
    }
}

