/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.bed;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.List;
import org.broad.tribble.AbstractFeatureReader;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.TribbleException;
import org.broad.tribble.annotation.Strand;
import org.broad.tribble.bed.BEDCodec;
import org.broad.tribble.bed.BEDFeature;
import org.broad.tribble.bed.FullBEDFeature;
import org.broad.tribble.index.IndexFactory;
import org.broad.tribble.index.linear.LinearIndex;
import org.broad.tribble.util.LittleEndianOutputStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BEDCodecTest {
    @Test
    public void testSimpleDecode() {
        BEDCodec codec = new BEDCodec();
        BEDFeature feature = codec.decode("chr1 1");
        Assert.assertEquals((String)feature.getChr(), (String)"chr1");
        Assert.assertEquals((int)feature.getStart(), (int)2);
        Assert.assertEquals((int)feature.getEnd(), (int)2);
        feature = codec.decode("chr1 1 2");
        Assert.assertEquals((String)feature.getChr(), (String)"chr1");
        Assert.assertEquals((int)feature.getStart(), (int)2);
        Assert.assertEquals((int)feature.getEnd(), (int)2);
        feature = codec.decode("chr1 1 3");
        Assert.assertEquals((String)feature.getChr(), (String)"chr1");
        Assert.assertEquals((int)feature.getStart(), (int)2);
        Assert.assertEquals((int)feature.getEnd(), (int)3);
    }

    @Test
    public void testFullDecode() {
        BEDCodec codec = new BEDCodec();
        FullBEDFeature feature = (FullBEDFeature)codec.decode("chr22 1000 5000 cloneA 960 + 1000 5000 0 2 567,488, 0,3512");
        Assert.assertEquals((String)feature.getChr(), (String)"chr22");
        Assert.assertEquals((int)feature.getStart(), (int)1001);
        Assert.assertEquals((int)feature.getEnd(), (int)5000);
        Assert.assertEquals((String)feature.getName(), (String)"cloneA");
        Assert.assertEquals((Object)Float.valueOf(feature.getScore()), (Object)Float.valueOf(960.0f));
        Assert.assertEquals((Object)((Object)feature.getStrand()), (Object)((Object)Strand.POSITIVE));
        Assert.assertEquals((Object)feature.getColor(), (Object)new Color(0));
        List<FullBEDFeature.Exon> exons = feature.getExons();
        Assert.assertEquals((int)exons.size(), (int)2);
        Assert.assertEquals((int)exons.get(0).getNumber(), (int)1);
        Assert.assertEquals((int)exons.get((int)0).start, (int)1001);
        Assert.assertEquals((int)exons.get((int)0).end, (int)1567);
        Assert.assertEquals((int)exons.get(0).getCdStart(), (int)1001);
        Assert.assertEquals((int)exons.get(0).getCdEnd(), (int)1567);
        Assert.assertEquals((int)exons.get(0).getCodingLength(), (int)567);
        Assert.assertEquals((int)exons.get(1).getNumber(), (int)2);
        Assert.assertEquals((int)exons.get((int)1).start, (int)4513);
        Assert.assertEquals((int)exons.get((int)1).end, (int)5000);
        Assert.assertEquals((int)exons.get(1).getCdStart(), (int)4513);
        Assert.assertEquals((int)exons.get(1).getCdEnd(), (int)5000);
        Assert.assertEquals((int)exons.get(1).getCodingLength(), (int)488);
        feature = (FullBEDFeature)codec.decode("chr22 2000 6000 cloneB 900 - 2000 6000 0 2 433,399, 0,3601");
        Assert.assertEquals((String)feature.getChr(), (String)"chr22");
        Assert.assertEquals((int)feature.getStart(), (int)2001);
        Assert.assertEquals((int)feature.getEnd(), (int)6000);
        Assert.assertEquals((String)feature.getName(), (String)"cloneB");
        Assert.assertEquals((Object)Float.valueOf(feature.getScore()), (Object)Float.valueOf(900.0f));
        Assert.assertEquals((Object)((Object)feature.getStrand()), (Object)((Object)Strand.NEGATIVE));
        Assert.assertEquals((Object)feature.getColor(), (Object)new Color(0));
        exons = feature.getExons();
        Assert.assertEquals((int)exons.size(), (int)2);
        Assert.assertEquals((int)exons.get(0).getNumber(), (int)2);
        Assert.assertEquals((int)exons.get((int)0).start, (int)2001);
        Assert.assertEquals((int)exons.get((int)0).end, (int)2433);
        Assert.assertEquals((int)exons.get(0).getCdStart(), (int)2001);
        Assert.assertEquals((int)exons.get(0).getCdEnd(), (int)2433);
        Assert.assertEquals((int)exons.get(0).getCodingLength(), (int)433);
        Assert.assertEquals((int)exons.get(1).getNumber(), (int)1);
        Assert.assertEquals((int)exons.get((int)1).start, (int)5602);
        Assert.assertEquals((int)exons.get((int)1).end, (int)6000);
        Assert.assertEquals((int)exons.get(1).getCdStart(), (int)5602);
        Assert.assertEquals((int)exons.get(1).getCdEnd(), (int)6000);
        Assert.assertEquals((int)exons.get(1).getCodingLength(), (int)399);
    }

    @Test
    public void testDecodeBEDFile_good() throws Exception {
        String filepath = "test/data/bed/NA12878.deletions.10kbp.het.gq99.hand_curated.hg19_fixed.bed";
        int expected_lines = 34;
        BEDCodec codec = new BEDCodec();
        AbstractFeatureReader reader = AbstractFeatureReader.getFeatureReader(filepath, (FeatureCodec)codec, false);
        CloseableTribbleIterator iter = reader.iterator();
        int count = 0;
        for (Feature feat : iter) {
            Assert.assertTrue((feat.getChr().length() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((feat.getEnd() >= feat.getStart() ? 1 : 0) != 0);
            if (count == 0) {
                Assert.assertEquals((String)"1", (String)feat.getChr());
                Assert.assertEquals((int)25592414, (int)feat.getStart());
                Assert.assertEquals((int)25657872, (int)feat.getEnd());
            }
            if (count == 3) {
                Assert.assertEquals((String)"1", (String)feat.getChr());
                Assert.assertEquals((int)152555537, (int)feat.getStart());
                Assert.assertEquals((int)152587611, (int)feat.getEnd());
            }
            if (count == 28) {
                Assert.assertEquals((String)"14", (String)feat.getChr());
                Assert.assertEquals((int)73996608, (int)feat.getStart());
                Assert.assertEquals((int)74025282, (int)feat.getEnd());
            }
            ++count;
        }
        Assert.assertEquals((int)expected_lines, (int)count);
        reader.close();
    }

    @Test
    public void testDecodeBEDFile_bad() throws Exception {
        String filepath = "test/data/bed/NA12878.deletions.10kbp.het.gq99.hand_curated.hg19.bed";
        int expected_count = 31;
        BEDCodec codec = new BEDCodec();
        AbstractFeatureReader reader = AbstractFeatureReader.getFeatureReader(filepath, (FeatureCodec)codec, false);
        CloseableTribbleIterator iter = reader.iterator();
        int count = 0;
        boolean excepted = false;
        try {
            for (Feature feat : iter) {
                ++count;
            }
        }
        catch (TribbleException.MalformedFeatureFile e) {
            excepted = true;
        }
        Assert.assertEquals((int)expected_count, (int)count);
        Assert.assertTrue((boolean)excepted);
        reader.close();
    }

    private void createIndex(File testFile, File idxFile) throws IOException {
        if (idxFile.exists()) {
            idxFile.delete();
        }
        LinearIndex idx = (LinearIndex)IndexFactory.createLinearIndex(testFile, new BEDCodec());
        FilterOutputStream stream = null;
        try {
            stream = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(idxFile)));
            idx.write((LittleEndianOutputStream)stream);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }
}

