/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.QueueMessageReference;
import org.apache.activemq.broker.region.cursors.AbstractPendingMessageCursor;
import org.apache.activemq.command.Message;
import org.apache.activemq.filter.NonCachedMessageEvaluationContext;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.store.kahadb.plist.PList;
import org.apache.activemq.store.kahadb.plist.PListEntry;
import org.apache.activemq.store.kahadb.plist.PListStore;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.usage.Usage;
import org.apache.activemq.usage.UsageListener;
import org.apache.activemq.wireformat.WireFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kahadb.util.ByteSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePendingMessageCursor
extends AbstractPendingMessageCursor
implements UsageListener {
    static final Log LOG = LogFactory.getLog(FilePendingMessageCursor.class);
    private static final AtomicLong NAME_COUNT = new AtomicLong();
    protected Broker broker;
    private final PListStore store;
    private final String name;
    private LinkedList<MessageReference> memoryList = new LinkedList();
    private PList diskList;
    private Iterator<MessageReference> iter;
    private Destination regionDestination;
    private boolean iterating;
    private boolean flushRequired;
    private final AtomicBoolean started = new AtomicBoolean();
    private final WireFormat wireFormat = new OpenWireFormat();

    public FilePendingMessageCursor(Broker broker, String name, boolean prioritizedMessages) {
        super(prioritizedMessages);
        this.useCache = false;
        this.broker = broker;
        this.store = broker.getTempDataStore();
        this.name = NAME_COUNT.incrementAndGet() + "_" + name;
    }

    @Override
    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            super.start();
            if (this.systemUsage != null) {
                this.systemUsage.getMemoryUsage().addUsageListener(this);
            }
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.started.compareAndSet(true, false)) {
            super.stop();
            if (this.systemUsage != null) {
                this.systemUsage.getMemoryUsage().removeUsageListener(this);
            }
        }
    }

    @Override
    public synchronized boolean isEmpty() {
        if (this.memoryList.isEmpty() && this.isDiskListEmpty()) {
            return true;
        }
        Iterator iterator = this.memoryList.iterator();
        while (iterator.hasNext()) {
            MessageReference node = (MessageReference)iterator.next();
            if (node == QueueMessageReference.NULL_MESSAGE) continue;
            if (!node.isDropped()) {
                return false;
            }
            iterator.remove();
        }
        return this.isDiskListEmpty();
    }

    @Override
    public synchronized void reset() {
        this.iterating = true;
        this.last = null;
        this.iter = this.isDiskListEmpty() ? this.memoryList.iterator() : new DiskIterator();
    }

    @Override
    public synchronized void release() {
        this.iterating = false;
        if (this.flushRequired) {
            this.flushRequired = false;
            this.flushToDisk();
        }
    }

    @Override
    public synchronized void destroy() throws Exception {
        this.stop();
        for (Message message : this.memoryList) {
            message.decrementReferenceCount();
        }
        this.memoryList.clear();
        this.destroyDiskList();
    }

    private void destroyDiskList() throws Exception {
        if (!this.isDiskListEmpty()) {
            this.store.removePList(this.name);
        }
    }

    @Override
    public synchronized LinkedList<MessageReference> pageInList(int maxItems) {
        int count;
        LinkedList<MessageReference> result = new LinkedList<MessageReference>();
        DiskIterator i = this.memoryList.iterator();
        for (count = 0; i.hasNext() && count < maxItems; ++count) {
            MessageReference ref = (MessageReference)i.next();
            ref.incrementReferenceCount();
            result.add(ref);
        }
        if (count < maxItems && !this.isDiskListEmpty()) {
            i = new DiskIterator();
            while (i.hasNext() && count < maxItems) {
                Message message = (Message)i.next();
                message.setRegionDestination(this.regionDestination);
                message.setMemoryUsage(this.getSystemUsage().getMemoryUsage());
                message.incrementReferenceCount();
                result.add(message);
                ++count;
            }
        }
        return result;
    }

    @Override
    public synchronized void addMessageLast(MessageReference node) throws Exception {
        this.tryAddMessageLast(node, 0L);
    }

    @Override
    public synchronized boolean tryAddMessageLast(MessageReference node, long maxWaitTime) throws Exception {
        if (!node.isExpired()) {
            try {
                this.regionDestination = node.getMessage().getRegionDestination();
                if (this.isDiskListEmpty() && (this.hasSpace() || this.store == null)) {
                    this.memoryList.add(node);
                    node.incrementReferenceCount();
                    return true;
                }
                if (!this.hasSpace() && this.isDiskListEmpty()) {
                    this.expireOldMessages();
                    if (this.hasSpace()) {
                        this.memoryList.add(node);
                        node.incrementReferenceCount();
                        return true;
                    }
                    this.flushToDisk();
                }
                if (this.systemUsage.getTempUsage().waitForSpace(maxWaitTime)) {
                    ByteSequence bs = this.getByteSequence(node.getMessage());
                    this.getDiskList().addLast(node.getMessageId().toString(), bs);
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                LOG.error("Caught an Exception adding a message: " + node + " first to FilePendingMessageCursor ", e);
                throw new RuntimeException(e);
            }
        }
        this.discard(node);
        return true;
    }

    @Override
    public synchronized void addMessageFirst(MessageReference node) {
        if (!node.isExpired()) {
            try {
                this.regionDestination = node.getMessage().getRegionDestination();
                if (this.isDiskListEmpty() && this.hasSpace()) {
                    this.memoryList.addFirst(node);
                    node.incrementReferenceCount();
                    return;
                }
                if (!this.hasSpace() && this.isDiskListEmpty()) {
                    this.expireOldMessages();
                    if (this.hasSpace()) {
                        this.memoryList.addFirst(node);
                        node.incrementReferenceCount();
                        return;
                    }
                    this.flushToDisk();
                }
                this.systemUsage.getTempUsage().waitForSpace();
                node.decrementReferenceCount();
                ByteSequence bs = this.getByteSequence(node.getMessage());
                this.getDiskList().addFirst(node.getMessageId().toString(), bs);
            }
            catch (Exception e) {
                LOG.error("Caught an Exception adding a message: " + node + " first to FilePendingMessageCursor ", e);
                throw new RuntimeException(e);
            }
        } else {
            this.discard(node);
        }
    }

    @Override
    public synchronized boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public synchronized MessageReference next() {
        Message message = (Message)this.iter.next();
        this.last = message;
        if (!this.isDiskListEmpty()) {
            message.setRegionDestination(this.regionDestination);
            message.setMemoryUsage(this.getSystemUsage().getMemoryUsage());
        }
        message.incrementReferenceCount();
        return message;
    }

    @Override
    public synchronized void remove() {
        this.iter.remove();
        if (this.last != null) {
            this.last.decrementReferenceCount();
        }
    }

    @Override
    public synchronized void remove(MessageReference node) {
        if (this.memoryList.remove(node)) {
            node.decrementReferenceCount();
        }
        if (!this.isDiskListEmpty()) {
            try {
                this.getDiskList().remove(node.getMessageId().toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public synchronized int size() {
        return this.memoryList.size() + (this.isDiskListEmpty() ? 0 : this.getDiskList().size());
    }

    @Override
    public synchronized void clear() {
        this.memoryList.clear();
        if (!this.isDiskListEmpty()) {
            try {
                this.getDiskList().destroy();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.last = null;
    }

    @Override
    public synchronized boolean isFull() {
        return super.isFull() || this.systemUsage != null && this.systemUsage.getTempUsage().isFull();
    }

    @Override
    public boolean hasMessagesBufferedToDeliver() {
        return !this.isEmpty();
    }

    @Override
    public void setSystemUsage(SystemUsage usageManager) {
        super.setSystemUsage(usageManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUsageChanged(Usage usage, int oldPercentUsage, int newPercentUsage) {
        if (newPercentUsage >= this.getMemoryUsageHighWaterMark()) {
            FilePendingMessageCursor filePendingMessageCursor = this;
            synchronized (filePendingMessageCursor) {
                this.flushRequired = true;
                if (!this.iterating) {
                    this.expireOldMessages();
                    if (!this.hasSpace()) {
                        this.flushToDisk();
                        this.flushRequired = false;
                    }
                }
            }
        }
    }

    @Override
    public boolean isTransient() {
        return true;
    }

    protected boolean isSpaceInMemoryList() {
        return this.hasSpace() && this.isDiskListEmpty();
    }

    protected synchronized void expireOldMessages() {
        if (!this.memoryList.isEmpty()) {
            LinkedList<MessageReference> tmpList = new LinkedList<MessageReference>(this.memoryList);
            this.memoryList = new LinkedList();
            while (!tmpList.isEmpty()) {
                MessageReference node = tmpList.removeFirst();
                if (node.isExpired()) {
                    this.discard(node);
                    continue;
                }
                this.memoryList.add(node);
            }
        }
    }

    protected synchronized void flushToDisk() {
        if (!this.memoryList.isEmpty()) {
            while (!this.memoryList.isEmpty()) {
                MessageReference node = this.memoryList.removeFirst();
                node.decrementReferenceCount();
                try {
                    ByteSequence bs = this.getByteSequence(node.getMessage());
                    this.getDiskList().addLast(node.getMessageId().toString(), bs);
                }
                catch (IOException e) {
                    LOG.error("Failed to write to disk list", e);
                    throw new RuntimeException(e);
                }
            }
            this.memoryList.clear();
        }
    }

    protected boolean isDiskListEmpty() {
        return this.diskList == null || this.diskList.isEmpty();
    }

    protected PList getDiskList() {
        if (this.diskList == null) {
            try {
                this.diskList = this.store.getPList(this.name);
            }
            catch (Exception e) {
                LOG.error("Caught an IO Exception getting the DiskList " + this.name, e);
                throw new RuntimeException(e);
            }
        }
        return this.diskList;
    }

    protected void discard(MessageReference message) {
        message.decrementReferenceCount();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Discarding message " + message);
        }
        this.broker.getRoot().sendToDeadLetterQueue(new ConnectionContext(new NonCachedMessageEvaluationContext()), message);
    }

    protected ByteSequence getByteSequence(Message message) throws IOException {
        org.apache.activemq.util.ByteSequence packet = this.wireFormat.marshal(message);
        return new ByteSequence(packet.data, packet.offset, packet.length);
    }

    protected Message getMessage(ByteSequence bs) throws IOException {
        org.apache.activemq.util.ByteSequence packet = new org.apache.activemq.util.ByteSequence(bs.getData(), bs.getOffset(), bs.getLength());
        return (Message)this.wireFormat.unmarshal(packet);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class DiskIterator
    implements Iterator<MessageReference> {
        private PListEntry next = null;
        private PListEntry current = null;
        PList list;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DiskIterator() {
            try {
                PList pList = this.list = FilePendingMessageCursor.this.getDiskList();
                synchronized (pList) {
                    this.next = this.current = this.list.getFirst();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MessageReference next() {
            this.current = this.next;
            try {
                ByteSequence bs = this.current.getByteSequence();
                PList pList = this.list;
                synchronized (pList) {
                    this.current = this.list.refresh(this.current);
                    this.next = this.list.getNext(this.current);
                }
                return FilePendingMessageCursor.this.getMessage(bs);
            }
            catch (IOException e) {
                LOG.error("I/O error", e);
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            try {
                PList pList = this.list;
                synchronized (pList) {
                    this.current = this.list.refresh(this.current);
                    this.list.remove(this.current);
                }
            }
            catch (IOException e) {
                LOG.error("I/O error", e);
                throw new RuntimeException(e);
            }
        }
    }
}

