/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.manager.web.ui;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Table;
import fi.csc.microarray.manager.web.ui.DateColumnGenerator;
import fi.csc.microarray.manager.web.ui.HumanReadableLongColumnGenerator;
import fi.csc.microarray.manager.web.ui.StorageView;

public class StorageEntryTable
extends Table {
    private StorageView view;

    public StorageEntryTable(StorageView view) {
        this.view = view;
        this.setSelectable(true);
        this.setImmediate(true);
        this.addValueChangeListener(view);
        this.setNullSelectionAllowed(false);
        this.setCacheRate(0.0);
        this.setSizeFull();
        this.addGeneratedColumn("size", new HumanReadableLongColumnGenerator());
        this.addGeneratedColumn("date", new DateColumnGenerator());
        this.addGeneratedColumn("deleteLink", new DeleteLinkColumnGenerator());
        this.setColumnWidth("date", 200);
    }

    class DeleteLinkColumnGenerator
    implements Table.ColumnGenerator {
        DeleteLinkColumnGenerator() {
        }

        public Component generateCell(Table source, final Object itemId, Object columnId) {
            Button link = new Button("Delete");
            link.setStyleName("link");
            link.addClickListener(new Button.ClickListener(){

                public void buttonClick(Button.ClickEvent event) {
                    StorageEntryTable.this.view.delete(itemId);
                }
            });
            return link;
        }
    }
}

