/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.manager.web.ui;

import com.vaadin.data.Property;
import com.vaadin.server.Resource;
import com.vaadin.server.ThemeResource;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.Table;
import com.vaadin.ui.VerticalLayout;
import fi.csc.microarray.manager.web.ChipsterAdminUI;
import fi.csc.microarray.manager.web.data.StatDataSource;
import fi.csc.microarray.manager.web.hbncontainer.HibernateUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.exception.GenericJDBCException;

public class StatView
extends VerticalLayout
implements Button.ClickListener {
    private Table monthlyStats;
    private Table yearlyStats;
    private Table topUsers;
    private Table toolFails;
    private Table toolUsage;
    private Table moduleUsage;
    private TabSheet tabSheet;
    private int selectedTab;
    private HorizontalLayout toolbarLayout;
    private Button refreshButton;
    private CheckBox ignoreTestAccounts;
    private Session session;
    private StatDataSource dataSource;
    private ChipsterAdminUI app;

    public StatView(ChipsterAdminUI app) {
        this.app = app;
        this.addComponent((Component)this.getToolbar());
        this.tabSheet = new TabSheet();
        this.updateData((Boolean)this.ignoreTestAccounts.getValue());
        this.tabSheet.setSizeFull();
        this.tabSheet.addSelectedTabChangeListener(new TabSheet.SelectedTabChangeListener(){

            public void selectedTabChange(TabSheet.SelectedTabChangeEvent e) {
                StatView.this.selectedTab = StatView.this.tabSheet.getTabPosition(StatView.this.tabSheet.getTab(StatView.this.tabSheet.getSelectedTab()));
            }
        });
        this.addComponent((Component)this.tabSheet);
        this.setExpandRatio((Component)this.tabSheet, 1.0f);
        this.setSizeFull();
    }

    private Session getHibernateSession() {
        if (this.session == null) {
            try {
                this.session = HibernateUtil.getSessionFactory().openSession();
            }
            catch (GenericJDBCException e) {
                e.printStackTrace();
            }
        }
        return this.session;
    }

    private void updateData(boolean ignoreTestAccounts) {
        Session session = this.getHibernateSession();
        if (this.dataSource == null) {
            this.dataSource = new StatDataSource();
        }
        this.monthlyStats = this.mapListToTable(this.dataSource.getMonthlyStats(session, ignoreTestAccounts));
        this.yearlyStats = this.mapListToTable(this.dataSource.getYearlyStats(session, ignoreTestAccounts));
        this.topUsers = this.mapListToTable(this.dataSource.getTopUsers(session, ignoreTestAccounts));
        this.toolFails = this.mapListToTable(this.dataSource.getToolFails(session, ignoreTestAccounts));
        this.toolUsage = this.mapListToTable(this.dataSource.getToolUsage(session, ignoreTestAccounts));
        this.moduleUsage = this.mapListToTable(this.dataSource.getModuleUsage(session, ignoreTestAccounts));
        this.monthlyStats.setVisibleColumns(this.dataSource.getMonthlyStatsColumnOrder());
        this.yearlyStats.setVisibleColumns(this.dataSource.getYearlyStatsColumnOrder());
        this.topUsers.setVisibleColumns(this.dataSource.getTopUsersColumnOrder());
        this.toolFails.setVisibleColumns(this.dataSource.getToolFailsColumnOrder());
        this.toolUsage.setVisibleColumns(this.dataSource.getToolUsageColumnOrder());
        this.moduleUsage.setVisibleColumns(this.dataSource.getModuleUsageColumnOrder());
        int lastSelectedTab = this.selectedTab;
        this.tabSheet.removeAllComponents();
        this.tabSheet.addTab((Component)this.monthlyStats, "Monthly statistics");
        this.tabSheet.addTab((Component)this.yearlyStats, "Yearly statistics");
        this.tabSheet.addTab((Component)this.toolUsage, "Tools usage (1 year)");
        this.tabSheet.addTab((Component)this.topUsers, "Top users (1 year)");
        this.tabSheet.addTab((Component)this.toolFails, "Tool fails (1 year)");
        this.tabSheet.addTab((Component)this.moduleUsage, "Module job counts (beta)");
        this.tabSheet.setSelectedTab(lastSelectedTab);
    }

    public HorizontalLayout getToolbar() {
        if (this.toolbarLayout == null) {
            this.toolbarLayout = new HorizontalLayout();
            this.refreshButton = new Button("Refresh");
            this.refreshButton.addClickListener((Button.ClickListener)this);
            this.refreshButton.setIcon((Resource)new ThemeResource("../runo/icons/32/reload.png"));
            this.refreshButton.setEnabled(true);
            this.toolbarLayout.addComponent((Component)this.refreshButton);
            this.ignoreTestAccounts = new CheckBox("Ignore test accounts", true);
            this.ignoreTestAccounts.addStyleName("toolbar-component");
            this.toolbarLayout.addComponent((Component)this.ignoreTestAccounts);
            this.ignoreTestAccounts.addValueChangeListener(new Property.ValueChangeListener(){

                public void valueChange(Property.ValueChangeEvent arg0) {
                    StatView.this.updateData((Boolean)StatView.this.ignoreTestAccounts.getValue());
                    StatView.this.tabSheet.setSelectedTab(StatView.this.selectedTab);
                }
            });
            Label spaceEater = new Label(" ");
            this.toolbarLayout.addComponent((Component)spaceEater);
            this.toolbarLayout.setExpandRatio((Component)spaceEater, 1.0f);
            this.toolbarLayout.addComponent(this.app.getTitle());
            this.toolbarLayout.setWidth("100%");
            this.toolbarLayout.setStyleName("toolbar");
        }
        return this.toolbarLayout;
    }

    private Table mapListToTable(List<Map<Object, Object>> list) {
        Table table = new Table();
        table.setSizeFull();
        if (list.size() > 0) {
            LinkedList<Object> keyList = new LinkedList<Object>(list.get(0).keySet());
            for (Object e : keyList) {
                table.addContainerProperty(e, String.class, null);
            }
            int i = 0;
            for (Map<Object, Object> map : list) {
                LinkedList<String> stringValues = new LinkedList<String>();
                for (Object objValue : map.values()) {
                    if (objValue != null) {
                        stringValues.add(objValue.toString());
                        continue;
                    }
                    stringValues.add("");
                }
                table.addItem(stringValues.toArray(), (Object)i++);
            }
        }
        return table;
    }

    public void buttonClick(Button.ClickEvent event) {
        if (event.getButton() == this.refreshButton) {
            this.updateData((Boolean)this.ignoreTestAccounts.getValue());
        }
    }
}

