/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.manager.web.ui;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Table;
import fi.csc.microarray.manager.web.ui.DateColumnGenerator;
import fi.csc.microarray.manager.web.ui.JobsView;

public class JobsTable
extends Table {
    private JobsView view;

    public JobsTable(JobsView view) {
        this.view = view;
        this.setSizeFull();
        this.setWidth("100%");
        this.setSelectable(true);
        this.setImmediate(true);
        this.addGeneratedColumn("startTime", new DateColumnGenerator());
        this.addGeneratedColumn("cancelLink", new CancelLinkColumnGenerator());
    }

    class CancelLinkColumnGenerator
    implements Table.ColumnGenerator {
        CancelLinkColumnGenerator() {
        }

        public Component generateCell(Table source, final Object itemId, Object columnId) {
            Button link = new Button("Cancel");
            link.setStyleName("link");
            link.setDescription("Cancel running job");
            link.addClickListener(new Button.ClickListener(){

                public void buttonClick(Button.ClickEvent event) {
                    JobsTable.this.select(itemId);
                    JobsTable.this.view.cancel(itemId);
                }
            });
            return link;
        }
    }
}

