/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.manager.web.data;

import fi.csc.microarray.manager.web.data.AccountEntry;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class TestAccountFilter {
    private List<String> testAccounts;

    private List<String> getTestAccounts(Session session) {
        if (this.testAccounts == null) {
            List results = session.createCriteria(AccountEntry.class).list();
            this.testAccounts = new LinkedList<String>();
            for (AccountEntry entry : results) {
                this.testAccounts.add(entry.getUsername());
            }
        }
        return this.testAccounts;
    }

    public void addCriteriaForTestAccounts(Session session, boolean ignoreTestAccounts, Criteria criteria) {
        if (ignoreTestAccounts) {
            for (String account : this.getTestAccounts(session)) {
                criteria.add(Restrictions.not((Criterion)Restrictions.eq((String)"username", (Object)account)));
            }
        }
    }

    public String getHqlForTestAccounts(Session session, boolean ignoreTestAccounts) {
        String hql = "where not ";
        if (ignoreTestAccounts) {
            boolean isFirst = true;
            List<String> accounts = this.getTestAccounts(session);
            for (String account : accounts) {
                if (!account.matches("^[a-zA-Z0-9]+$")) continue;
                if (!isFirst) {
                    hql = hql + "and not ";
                }
                isFirst = false;
                hql = hql + "username='" + account + "' ";
            }
            if (accounts.size() > 0) {
                return hql;
            }
        }
        return "";
    }
}

