/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.manager.web.data;

import com.vaadin.data.util.BeanItemContainer;
import fi.csc.microarray.manager.web.data.StorageAggregate;
import fi.csc.microarray.manager.web.data.StorageEntry;
import fi.csc.microarray.manager.web.data.StorageEntryContainer;
import fi.csc.microarray.manager.web.ui.StorageView;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class StorageAggregateContainer
extends BeanItemContainer<StorageAggregate>
implements Serializable {
    public static final String USERNAME = "username";
    public static final String SIZE = "size";
    public static final Object[] NATURAL_COL_ORDER = new String[]{"username", "size"};
    public static final String[] COL_HEADERS_ENGLISH = new String[]{"Username", "Total size"};
    public final String TOTAL_USERNAME = "TOTAL";
    private StorageEntryContainer entryContainer;
    private long diskUsage = 0L;
    private long diskAvailable = 0L;

    public long getDiskUsage() {
        return this.diskUsage;
    }

    public long getDiskAvailable() {
        return this.diskAvailable;
    }

    public StorageAggregateContainer(StorageEntryContainer entryContainer) throws InstantiationException, IllegalAccessException {
        super(StorageAggregate.class);
        this.entryContainer = entryContainer;
    }

    public StorageAggregate update(StorageView view) {
        this.removeAllItems();
        long totalSize = 0L;
        HashMap<String, Long> aggregateMap = new HashMap<String, Long>();
        this.entryContainer.removeAllContainerFilters();
        for (StorageEntry entry : this.entryContainer.getItemIds()) {
            String username = entry.getUsername();
            if (!aggregateMap.containsKey(username)) {
                aggregateMap.put(username, entry.getSize());
            } else {
                aggregateMap.put(username, (Long)aggregateMap.get(username) + entry.getSize());
            }
            totalSize += entry.getSize();
        }
        StorageAggregate totalBean = new StorageAggregate();
        totalBean.setUsername("TOTAL");
        totalBean.setSize(totalSize);
        this.addBean(totalBean);
        for (Map.Entry aggregate : aggregateMap.entrySet()) {
            StorageAggregate bean = new StorageAggregate();
            bean.setUsername((String)aggregate.getKey());
            bean.setSize((Long)aggregate.getValue());
            this.addBean(bean);
        }
        this.diskUsage = totalSize;
        this.diskAvailable = 500000000000L;
        return totalBean;
    }
}

