/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.manager.web.data;

import com.vaadin.server.FileResource;
import com.vaadin.server.VaadinService;
import fi.csc.microarray.manager.web.data.JobLogEntry;
import fi.csc.microarray.manager.web.data.TestAccountFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.core.io.ClassPathResource;

public class StatDataSource {
    public static final String ROW_COUNT = "count";
    public static final String YEAR = "year";
    public static final String MONTH = "month";
    public static final String JOB_COUNT = "jobCount";
    public static final String UNIQUE_USERS = "uniqueUsers";
    public static final String MICROARRAY = "microarray";
    public static final String NGS = "ngs";
    public static final String UNRESOLVED = "unresolved";
    public static final String OTHER = "other";
    private TestAccountFilter testAccountFilter = new TestAccountFilter();

    public List<Map<Object, Object>> getTopUsers(Session session, boolean ignoreTestAccounts) {
        GregorianCalendar fromDate = new GregorianCalendar();
        fromDate.set(1, fromDate.get(1) - 1);
        Criteria criteria = session.createCriteria(JobLogEntry.class);
        this.testAccountFilter.addCriteriaForTestAccounts(session, ignoreTestAccounts, criteria);
        criteria.add((Criterion)Restrictions.ge((String)"startTime", (Object)fromDate.getTime()));
        criteria.setProjection((Projection)Projections.projectionList().add(Projections.rowCount(), ROW_COUNT).add((Projection)Projections.groupProperty((String)"username"), "username"));
        criteria.addOrder(Order.desc((String)ROW_COUNT));
        criteria.setMaxResults(1000);
        criteria.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        LinkedList<HashMap<String, Object>> results = criteria.list();
        if (results == null || results.size() == 0) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("username", null);
            map.put(ROW_COUNT, null);
            results = new LinkedList<HashMap<String, Object>>();
            results.add(map);
        }
        return this.typedMap((List<Map>)results);
    }

    public Object[] getTopUsersColumnOrder() {
        return new Object[]{"username", ROW_COUNT};
    }

    private Map getJobDateRange(Session session, boolean ignoreTestAccounts) {
        Criteria rangeCriteria = session.createCriteria(JobLogEntry.class);
        this.testAccountFilter.addCriteriaForTestAccounts(session, ignoreTestAccounts, rangeCriteria);
        ProjectionList projections = Projections.projectionList();
        projections.add((Projection)Projections.min((String)"startTime"), "min");
        projections.add((Projection)Projections.max((String)"startTime"), "max");
        rangeCriteria.setProjection((Projection)projections);
        rangeCriteria.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        List rangeList = rangeCriteria.list();
        return (Map)rangeList.get(0);
    }

    public List<Map<Object, Object>> getMonthlyStats(Session session, boolean ignoreTestAccounts) {
        Map rangeMap = this.getJobDateRange(session, ignoreTestAccounts);
        Date min = (Date)rangeMap.get("min");
        Date max = (Date)rangeMap.get("max");
        LinkedList<Map<Object, Object>> results = new LinkedList<Map<Object, Object>>();
        if (min != null || max != null) {
            GregorianCalendar minDate = new GregorianCalendar();
            GregorianCalendar maxDate = new GregorianCalendar();
            minDate.setTime(min);
            maxDate.setTime(max);
            int minYear = minDate.get(1);
            int maxYear = maxDate.get(1);
            int minMonth = minDate.get(2) + 1;
            int maxMonth = maxDate.get(2) + 1;
            for (int year = minYear; year <= maxYear; ++year) {
                for (int month = year == minYear ? minMonth : 1; month <= 12 && (year != maxYear || month <= maxMonth); ++month) {
                    GregorianCalendar startDate = new GregorianCalendar();
                    startDate.set(year, month - 1, 1, 0, 0, 0);
                    Calendar endDate = (Calendar)((Calendar)startDate).clone();
                    endDate.add(2, 1);
                    Criteria criteria = session.createCriteria(JobLogEntry.class);
                    this.testAccountFilter.addCriteriaForTestAccounts(session, ignoreTestAccounts, criteria);
                    criteria.add((Criterion)Restrictions.ge((String)"startTime", (Object)startDate.getTime()));
                    criteria.add((Criterion)Restrictions.lt((String)"startTime", (Object)endDate.getTime()));
                    criteria.setProjection((Projection)Projections.projectionList().add(Projections.rowCount(), JOB_COUNT).add((Projection)Projections.countDistinct((String)"username"), UNIQUE_USERS));
                    criteria.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
                    List resultList = criteria.list();
                    Map resultMap = (Map)resultList.get(0);
                    resultMap.put(YEAR, year);
                    resultMap.put(MONTH, month);
                    results.add(resultMap);
                }
            }
        } else {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put(YEAR, null);
            resultMap.put(MONTH, null);
            resultMap.put(UNIQUE_USERS, null);
            resultMap.put(JOB_COUNT, null);
            results.add(resultMap);
        }
        return results;
    }

    public Object[] getMonthlyStatsColumnOrder() {
        return new Object[]{YEAR, MONTH, UNIQUE_USERS, JOB_COUNT};
    }

    public List<Map<Object, Object>> getYearlyStats(Session session, boolean ignoreTestAccounts) {
        Map rangeMap = this.getJobDateRange(session, ignoreTestAccounts);
        GregorianCalendar minDate = new GregorianCalendar();
        GregorianCalendar maxDate = new GregorianCalendar();
        Date min = (Date)rangeMap.get("min");
        Date max = (Date)rangeMap.get("max");
        LinkedList<Map<Object, Object>> results = new LinkedList<Map<Object, Object>>();
        if (min != null || max != null) {
            minDate.setTime(min);
            maxDate.setTime(max);
            int minYear = minDate.get(1);
            int maxYear = maxDate.get(1);
            for (int year = minYear; year <= maxYear; ++year) {
                GregorianCalendar startDate = new GregorianCalendar();
                startDate.set(year, 0, 1, 0, 0, 0);
                Calendar endDate = (Calendar)((Calendar)startDate).clone();
                endDate.add(1, 1);
                Criteria criteria = session.createCriteria(JobLogEntry.class);
                this.testAccountFilter.addCriteriaForTestAccounts(session, ignoreTestAccounts, criteria);
                criteria.add((Criterion)Restrictions.ge((String)"startTime", (Object)startDate.getTime()));
                criteria.add((Criterion)Restrictions.lt((String)"startTime", (Object)endDate.getTime()));
                criteria.setProjection((Projection)Projections.projectionList().add(Projections.rowCount(), JOB_COUNT).add((Projection)Projections.countDistinct((String)"username"), UNIQUE_USERS));
                criteria.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
                List resultList = criteria.list();
                Map resultMap = (Map)resultList.get(0);
                resultMap.put(YEAR, year);
                results.add(resultMap);
            }
        } else {
            HashMap<Object, Object> resultMap = new HashMap<Object, Object>();
            for (Object key : this.getYearlyStatsColumnOrder()) {
                resultMap.put(key, null);
            }
            results.add(resultMap);
        }
        return results;
    }

    public Object[] getYearlyStatsColumnOrder() {
        return new Object[]{YEAR, UNIQUE_USERS, JOB_COUNT};
    }

    public List<Map<Object, Object>> getToolFails(Session session, boolean ignoreTestAccounts) {
        GregorianCalendar fromDate = new GregorianCalendar();
        fromDate.set(1, fromDate.get(1) - 1);
        Criteria criteria = session.createCriteria(JobLogEntry.class);
        this.testAccountFilter.addCriteriaForTestAccounts(session, ignoreTestAccounts, criteria);
        LinkedList<HashMap<String, Object>> results = criteria.add((Criterion)Restrictions.ge((String)"startTime", (Object)fromDate.getTime())).add((Criterion)Restrictions.eq((String)"status", (Object)"FAILED")).setProjection((Projection)Projections.projectionList().add(Projections.rowCount(), ROW_COUNT).add((Projection)Projections.groupProperty((String)"operation"), "operation")).addOrder(Order.desc((String)ROW_COUNT)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP).list();
        if (results == null || results.size() == 0) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("operation", null);
            map.put(ROW_COUNT, null);
            results = new LinkedList<HashMap<String, Object>>();
            results.add(map);
        }
        return this.typedMap((List<Map>)results);
    }

    public Object[] getToolFailsColumnOrder() {
        return new Object[]{"operation", ROW_COUNT};
    }

    public List<Map<Object, Object>> getToolUsage(Session session, boolean ignoreTestAccounts) {
        GregorianCalendar fromDate = new GregorianCalendar();
        fromDate.set(1, fromDate.get(1) - 1);
        Criteria criteria = session.createCriteria(JobLogEntry.class);
        this.testAccountFilter.addCriteriaForTestAccounts(session, ignoreTestAccounts, criteria);
        LinkedList<HashMap<String, Object>> results = criteria.add((Criterion)Restrictions.ge((String)"startTime", (Object)fromDate.getTime())).setProjection((Projection)Projections.projectionList().add(Projections.rowCount(), ROW_COUNT).add((Projection)Projections.groupProperty((String)"operation"), "operation")).addOrder(Order.desc((String)ROW_COUNT)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP).list();
        if (results == null || results.size() == 0) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("operation", null);
            map.put(ROW_COUNT, null);
            results = new LinkedList<HashMap<String, Object>>();
            results.add(map);
        }
        return this.typedMap((List<Map>)results);
    }

    public Object[] getToolUsageColumnOrder() {
        return new Object[]{"operation", ROW_COUNT};
    }

    public List<Map<Object, Object>> getModuleUsage(Session session, boolean ignoreTestAccounts) {
        Map rangeMap = this.getJobDateRange(session, ignoreTestAccounts);
        GregorianCalendar minDate = new GregorianCalendar();
        GregorianCalendar maxDate = new GregorianCalendar();
        Date min = (Date)rangeMap.get("min");
        Date max = (Date)rangeMap.get("max");
        LinkedList<Map<Object, Object>> moduleResults = new LinkedList<Map<Object, Object>>();
        if (min != null || max != null) {
            minDate.setTime(min);
            maxDate.setTime(max);
            int minYear = minDate.get(1);
            int maxYear = maxDate.get(1);
            LinkedList<Map> results = new LinkedList<Map>();
            for (int year = minYear; year <= maxYear; ++year) {
                GregorianCalendar startDate = new GregorianCalendar();
                startDate.set(year, 0, 1, 0, 0, 0);
                Calendar endDate = (Calendar)((Calendar)startDate).clone();
                endDate.add(1, 1);
                Criteria criteria = session.createCriteria(JobLogEntry.class);
                this.testAccountFilter.addCriteriaForTestAccounts(session, ignoreTestAccounts, criteria);
                criteria.add((Criterion)Restrictions.ge((String)"startTime", (Object)startDate.getTime()));
                criteria.add((Criterion)Restrictions.lt((String)"startTime", (Object)endDate.getTime()));
                criteria.setProjection((Projection)Projections.projectionList().add(Projections.rowCount(), ROW_COUNT).add((Projection)Projections.groupProperty((String)"operation"), "operation"));
                criteria.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
                List resultList = criteria.list();
                for (Map toolCount : resultList) {
                    toolCount.put(YEAR, year);
                    results.add(toolCount);
                }
            }
            String microarray = null;
            String ngs = null;
            try {
                microarray = this.readFile(new ClassPathResource("WebContent/WEB-INF/microarray-module-copy.xml").getInputStream());
                ngs = this.readFile(new ClassPathResource("WebContent/WEB-INF/ngs-module-copy.xml").getInputStream());
            }
            catch (FileNotFoundException e) {
                try {
                    String basepath = VaadinService.getCurrent().getBaseDirectory().getAbsolutePath();
                    microarray = this.readFile(new FileResource(new File(basepath + "/WEB-INF/microarray-module-copy.xml")).getSourceFile());
                    ngs = this.readFile(new FileResource(new File(basepath + "/WEB-INF/ngs-module-copy.xml")).getSourceFile());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            HashMap<String, String> toolModuleMap = new HashMap<String, String>();
            for (Map resultMap : results) {
                String string = (String)resultMap.get("operation");
                if (toolModuleMap.containsKey(string)) continue;
                boolean isMicroarray = microarray.contains(string);
                boolean isNgs = ngs.contains(string);
                if (isMicroarray && !isNgs) {
                    toolModuleMap.put(string, MICROARRAY);
                    continue;
                }
                if (isNgs && !isMicroarray) {
                    toolModuleMap.put(string, NGS);
                    continue;
                }
                if (isNgs && isMicroarray) {
                    toolModuleMap.put(string, UNRESOLVED);
                    continue;
                }
                if (isNgs || isMicroarray) continue;
                toolModuleMap.put(string, OTHER);
            }
            TreeMap yearModuleCount = new TreeMap();
            for (Map map : results) {
                String module;
                Map moduleCountMap;
                String tool = (String)map.get("operation");
                Integer year = (Integer)map.get(YEAR);
                Integer toolCount = (int)((Long)map.get(ROW_COUNT)).longValue();
                if (!yearModuleCount.containsKey(year)) {
                    yearModuleCount.put(year, new HashMap());
                }
                if (!(moduleCountMap = (Map)yearModuleCount.get(year)).containsKey(module = (String)toolModuleMap.get(tool))) {
                    moduleCountMap.put(module, toolCount);
                    continue;
                }
                moduleCountMap.put(module, (Integer)moduleCountMap.get(module) + toolCount);
            }
            for (Map.Entry entry : yearModuleCount.entrySet()) {
                HashMap<String, Object> moduleMap = new HashMap<String, Object>();
                int microarrayCount = 0;
                int ngsCount = 0;
                int unresolvedCount = 0;
                int otherCount = 0;
                if (((Map)entry.getValue()).containsKey(MICROARRAY)) {
                    microarrayCount = (Integer)((Map)entry.getValue()).get(MICROARRAY);
                }
                if (((Map)entry.getValue()).containsKey(NGS)) {
                    ngsCount = (Integer)((Map)entry.getValue()).get(NGS);
                }
                if (((Map)entry.getValue()).containsKey(UNRESOLVED)) {
                    unresolvedCount = (Integer)((Map)entry.getValue()).get(UNRESOLVED);
                }
                if (((Map)entry.getValue()).containsKey(OTHER)) {
                    otherCount = (Integer)((Map)entry.getValue()).get(OTHER);
                }
                moduleMap.put(YEAR, entry.getKey());
                moduleMap.put(MICROARRAY, microarrayCount);
                moduleMap.put(NGS, ngsCount);
                moduleMap.put(UNRESOLVED, unresolvedCount);
                moduleMap.put(OTHER, otherCount);
                moduleResults.add(moduleMap);
            }
        } else {
            HashMap<Object, Object> moduleMap = new HashMap<Object, Object>();
            for (Object key : this.getModuleUsageColumnOrder()) {
                moduleMap.put(key, null);
            }
            moduleResults.add(moduleMap);
        }
        return moduleResults;
    }

    public Object[] getModuleUsageColumnOrder() {
        return new Object[]{YEAR, MICROARRAY, NGS, UNRESOLVED, OTHER};
    }

    private List<Map<Object, Object>> typedMap(List<Map> rawtype) {
        LinkedList<Map<Object, Object>> typed = new LinkedList<Map<Object, Object>>();
        for (Map rawItem : rawtype) {
            typed.add(rawItem);
        }
        return typed;
    }

    private String readFile(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
            stringBuilder.append(ls);
        }
        reader.close();
        return stringBuilder.toString();
    }

    private String readFile(InputStream file) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(file));
        String line = null;
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
            stringBuilder.append(ls);
        }
        reader.close();
        return stringBuilder.toString();
    }
}

