/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.features.stat;

import fi.csc.microarray.databeans.features.CalculatingIterable;
import fi.csc.microarray.databeans.features.Feature;
import fi.csc.microarray.databeans.features.ModifiedFeature;
import fi.csc.microarray.exception.MicroarrayException;
import java.util.List;

public class CalcModifier {
    private CalcModifierFeature output;
    private final CalculatingIterable.CalcOperation operation;

    public CalcModifier(CalculatingIterable.CalcOperation operation) {
        this.operation = operation;
    }

    public Feature getOutput() {
        return this.output;
    }

    public void setInputs(List<Feature> inputs) {
        this.output = new CalcModifierFeature(inputs, this.operation);
    }

    protected static class CalcModifierFeature
    extends ModifiedFeature {
        private Feature original;
        private CalculatingIterable.CalcOperation operation;

        protected CalcModifierFeature(List<Feature> inputs, CalculatingIterable.CalcOperation operation) {
            super(inputs);
            if (inputs.size() != 1) {
                throw new IllegalArgumentException("calc modifier must have 1 parameter");
            }
            this.original = inputs.get(0);
            this.operation = operation;
        }

        @Override
        public Iterable<Float> asFloats() throws MicroarrayException {
            return new CalculatingIterable(this.original.asFloats(), null, this.operation);
        }
    }
}

