/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.threed;

import fi.csc.microarray.client.visualisation.methods.threed.CoordinateArea;
import java.awt.Color;
import java.awt.Graphics;

public abstract class Drawable
implements Comparable<Drawable> {
    public double[][] visualisationCoords;
    public double[][] projectedCoords;
    public int[][] deviceCoords;
    public double[][] dataCoords;
    public boolean selected = false;
    public boolean hidden = false;
    protected Color color;
    protected String text;
    protected double[] distanceFromCamera;

    public abstract void draw(Graphics var1, int var2, int var3, CoordinateArea.PaintMode var4);

    public abstract void setDistanceFromCamera(double[] var1, double var2, double var4, double var6);

    public double[] getDistanceFromCamera() {
        return this.distanceFromCamera;
    }

    @Override
    public int compareTo(Drawable other) {
        int i;
        if (other == null) {
            return -1;
        }
        double thisMax = Double.MIN_VALUE;
        double otherMin = Double.MAX_VALUE;
        double[] d2 = other.getDistanceFromCamera();
        for (i = 0; i < this.distanceFromCamera.length; ++i) {
            thisMax += this.distanceFromCamera[i] / (double)this.distanceFromCamera.length;
        }
        for (i = 0; i < d2.length; ++i) {
            otherMin += d2[i] / (double)d2.length;
        }
        if (thisMax < otherMin) {
            return 1;
        }
        if (thisMax > otherMin) {
            return -1;
        }
        return 0;
    }
}

