/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserConstants;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserPlot;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.CytobandTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.EmptyTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.GeneTrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.PeakTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReadSummaryTrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReadTrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.SeparatorTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.SeparatorTrack3D;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TitleTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import java.awt.Color;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;

public class TrackFactory {
    public static TrackGroup getGeneTrackGroup(GBrowserPlot genomePlot, AreaRequestHandler annotationDataSource, AreaRequestHandler repeatDataSource, boolean isUserData) throws FileNotFoundException {
        GBrowserView dataView = genomePlot.getDataView();
        GeneTrackGroup geneGroup = new GeneTrackGroup(dataView, annotationDataSource, repeatDataSource, isUserData);
        return geneGroup;
    }

    public static TrackGroup getThinSeparatorTrackGroup(GBrowserPlot genomePlot) {
        GBrowserView view = genomePlot.getDataView();
        TrackGroup group = new TrackGroup(view);
        SeparatorTrack separator = new SeparatorTrack(Color.LIGHT_GRAY, 3, 0L, Long.MAX_VALUE);
        separator.setView(view);
        group.addTrack(separator);
        return group;
    }

    public static TrackGroup getThickSeparatorTrackGroup(GBrowserPlot genomePlot) {
        GBrowserView view = genomePlot.getDataView();
        TrackGroup group = new TrackGroup(view);
        SeparatorTrack3D separator1 = new SeparatorTrack3D(0L, Long.MAX_VALUE, false);
        separator1.setView(view);
        group.addTrack(separator1);
        EmptyTrack empty = new EmptyTrack(2);
        empty.setView(view);
        group.addTrack(empty);
        SeparatorTrack3D separator2 = new SeparatorTrack3D(0L, Long.MAX_VALUE, true);
        separator2.setView(view);
        group.addTrack(separator2);
        return group;
    }

    public static TrackGroup getReadTrackGroup(GBrowserPlot genomePlot, AreaRequestHandler userData, AreaRequestHandler seqFile, String title) throws FileNotFoundException, MalformedURLException {
        GBrowserView dataView = genomePlot.getDataView();
        ReadTrackGroup readGroup = new ReadTrackGroup(dataView, userData, seqFile, title);
        readGroup.initialise();
        return readGroup;
    }

    public static TrackGroup getReadSummaryTrackGroup(GBrowserPlot genomePlot, AreaRequestHandler userData, AreaRequestHandler seqFile, String title, AreaRequestHandler summaryDataSource) throws FileNotFoundException, MalformedURLException {
        GBrowserView dataView = genomePlot.getDataView();
        ReadSummaryTrackGroup readGroup = new ReadSummaryTrackGroup(dataView, userData, seqFile, title, summaryDataSource);
        readGroup.initialise();
        return readGroup;
    }

    public static TrackGroup getPeakTrackGroup(GBrowserPlot plot, AreaRequestHandler areaRequestHandler) {
        GBrowserView dataView = plot.getDataView();
        PeakTrack annotation = new PeakTrack(GBrowserConstants.BED_COLOR, 0L, Long.MAX_VALUE);
        annotation.setView(dataView);
        annotation.setAreaRequestHandler(areaRequestHandler);
        return new TrackGroup(annotation);
    }

    public static TrackGroup getCytobandTrackGroup(GBrowserPlot plot, AreaRequestHandler cytobandData) {
        CytobandTrack overviewCytobands = new CytobandTrack(false);
        overviewCytobands.setView(plot.getOverviewView());
        overviewCytobands.setAreaRequestHandler(cytobandData);
        return new TrackGroup(overviewCytobands);
    }

    public static TitleTrack getTitleTrack(GBrowserPlot genomePlot, String title) {
        GBrowserView dataView = genomePlot.getDataView();
        TitleTrack titleTrack = new TitleTrack(title, Color.black);
        titleTrack.setView(dataView);
        return titleTrack;
    }
}

