/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.stack;

import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.RandomAccessLineReader;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;

public class RandomAccessLineReaderTest {
    private static final int TEST_FILE_ROWS = 1000;

    public static void main(String[] args) throws IOException, URISyntaxException, GBrowserException {
        String line;
        String line2;
        int j;
        int i;
        File emptyFile = File.createTempFile("RandomAccesLineReaderTest", ".txt");
        RandomAccessLineReader lineReader = new RandomAccessLineReader(emptyFile.toURI().toURL());
        System.out.println(!lineReader.setPosition(0L));
        emptyFile.delete();
        File testFile = RandomAccessLineReaderTest.getTestFile();
        List<String> lines = RandomAccessLineReaderTest.getTestReferenceList(testFile);
        lineReader = new RandomAccessLineReader(testFile.toURI().toURL());
        System.out.println(lineReader.length() == testFile.length());
        System.out.println(!lineReader.setPosition(-1L));
        System.out.println(!lineReader.setPosition(testFile.length()));
        boolean readLineException = false;
        try {
            lineReader.readLine();
        }
        catch (IOException e) {
            readLineException = true;
        }
        System.out.println(readLineException);
        System.out.println(lineReader.setPosition(0L));
        lineReader.setPosition(0L);
        for (String refernceLine : lines) {
            String line3 = lineReader.readLine();
            RandomAccessLineReaderTest.testLineComparison(refernceLine, line3);
        }
        int testLinePosition = 0;
        for (int i2 = 0; i2 < 500; ++i2) {
            testLinePosition += lines.get(i2).length() + 1;
        }
        String[] line500 = new String[]{"M499-", "499-", "99-", "9-", "-", ""};
        for (i = 0; i < 6; ++i) {
            j = testLinePosition - 6 + i;
            lineReader.setPosition(j - 1024);
            lineReader.readLine();
            lineReader.setPosition(j);
            line2 = lineReader.readLine();
            RandomAccessLineReaderTest.testLineComparison(line500[i], line2);
        }
        for (i = 0; i < 6; ++i) {
            j = testLinePosition - 6 + i;
            lineReader.setPosition(8192L);
            lineReader.readLine();
            lineReader.setPosition(j);
            line2 = lineReader.readLine();
            RandomAccessLineReaderTest.testLineComparison(line500[i], line2);
        }
        for (i = 0; i < 6; ++i) {
            j = testLinePosition - 6 + i;
            boolean BUFFER_BYTES_LEFT = true;
            lineReader.setPosition(j - 4096 + 1);
            lineReader.readLine();
            if (lineReader.setPosition(j)) {
                line = lineReader.readLine();
                RandomAccessLineReaderTest.testLineComparison(line500[i], line);
                continue;
            }
            System.err.println("setPosition failed");
        }
        String[] endOfFile = new String[]{"-M999-", "M999-", "999-", "99-", "9-", "-", ""};
        for (int i3 = 0; i3 < 7; ++i3) {
            int j2 = i3 - 7;
            lineReader.setPosition(testFile.length() + (long)j2);
            line = lineReader.readLine();
            RandomAccessLineReaderTest.testLineComparison(endOfFile[i3], line);
        }
        System.out.println(lineReader.readLine() == null);
        testFile.delete();
    }

    private static void testLineComparison(String refernceLine, String line) {
        if (!refernceLine.equals(line)) {
            System.err.println("Unequal lines, \n\tRef:  \t" + refernceLine + "\n\tTest: \t" + line);
        }
    }

    public static List<String> getTestReferenceList(File testFile) throws FileNotFoundException, IOException {
        String line;
        LinkedList<String> lines = new LinkedList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(testFile));
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        reader.close();
        return lines;
    }

    public static File getTestFile() throws IOException {
        File testFile = File.createTempFile("RandomAccessLineReader-test-file", ".txt");
        BufferedWriter writer = new BufferedWriter(new FileWriter(testFile));
        String[] cols = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M"};
        for (int i = 0; i < 1000; ++i) {
            String row = String.format("%03d", i);
            String line = "";
            for (String col : cols) {
                line = line + col + row + "-";
            }
            writer.write(line);
            writer.newLine();
        }
        writer.flush();
        writer.close();
        return testFile;
    }
}

