/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.gui;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaResultListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.RegionListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataRetrievalStatus;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.QueueManager;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class ViewLimiter
implements RegionListener {
    private QueueManager queueManager;
    private AreaRequestHandler cytobandDataSource;
    private BpCoord limit;
    private List<RegionListener> limitChangeListeners = new LinkedList<RegionListener>();

    public ViewLimiter(QueueManager queueManager, AreaRequestHandler cytobandRequestHandler, GBrowserView view) {
        this.queueManager = queueManager;
        this.cytobandDataSource = cytobandRequestHandler;
        queueManager.addResultListener(cytobandRequestHandler, new AreaResultListener(){

            @Override
            public void processAreaResult(AreaResult areaResult) {
                if (ViewLimiter.this.limit != null) {
                    Long previousLimit = ((ViewLimiter)ViewLimiter.this).limit.bp;
                    for (RegionContent regCont : areaResult.getContents()) {
                        BpCoord value = regCont.region.end;
                        if (!value.chr.equals(((ViewLimiter)ViewLimiter.this).limit.chr) || value.bp <= ((ViewLimiter)ViewLimiter.this).limit.bp) continue;
                        ((ViewLimiter)ViewLimiter.this).limit.bp = value.bp;
                    }
                    if (!previousLimit.equals(((ViewLimiter)ViewLimiter.this).limit.bp)) {
                        for (RegionListener listener : ViewLimiter.this.limitChangeListeners) {
                            listener.regionChanged(new Region(0L, ((ViewLimiter)ViewLimiter.this).limit.bp, ((ViewLimiter)ViewLimiter.this).limit.chr));
                        }
                    }
                }
            }
        });
        view.addRegionListener(this);
    }

    @Override
    public void regionChanged(Region bpRegion) {
        if (this.limit == null || !this.limit.chr.equals(bpRegion.start.chr)) {
            this.limit = new BpCoord(0L, bpRegion.start.chr);
            this.queueManager.addAreaRequest(this.cytobandDataSource, new AreaRequest(new Region(0L, Long.MAX_VALUE, bpRegion.start.chr), new HashSet<ColumnType>(Arrays.asList(ColumnType.VALUE)), new DataRetrievalStatus()), false);
        }
    }

    public BpCoord getLimit() {
        if (this.limit != null) {
            return this.limit.clone();
        }
        return null;
    }

    public void addLimitChangeListener(RegionListener listener) {
        this.limitChangeListeners.add(listener);
    }

    public void removeLimitChangeListeners(RegionListener listener) {
        this.limitChangeListeners.remove(listener);
    }
}

