/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.DataSource;
import fi.csc.microarray.util.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;

public class ChunkDataSource
extends DataSource {
    private RandomAccessFile raFile;
    private Long length = null;

    public ChunkDataSource(URL url, Class<? extends AreaRequestHandler> requestHandler) throws FileNotFoundException, URISyntaxException {
        super(url, requestHandler);
        if (this.file != null) {
            this.raFile = new RandomAccessFile(this.file.getPath(), "r");
        }
    }

    public ChunkDataSource(URL urlRoot, String path, Class<? extends AreaRequestHandler> requestHandler) throws FileNotFoundException, MalformedURLException, URISyntaxException {
        super(urlRoot, path, requestHandler);
        if (this.file != null) {
            this.raFile = new RandomAccessFile(this.file.getPath(), "r");
        }
    }

    public int read(long filePosition, byte[] chunk) throws IOException {
        return this.read(filePosition, chunk, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(long filePosition, byte[] chunk, boolean retry) throws IOException {
        int n;
        if (this.raFile != null) {
            this.raFile.seek(filePosition);
            return this.raFile.read(chunk);
        }
        long endFilePosition = filePosition + (long)chunk.length;
        if (endFilePosition > this.length()) {
            endFilePosition = this.length();
        }
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)this.url.openConnection();
            connection.setRequestProperty("Range", "bytes=" + filePosition + "-" + endFilePosition);
            int bytes = connection.getInputStream().read(chunk);
            if (retry && (long)bytes < endFilePosition - filePosition && bytes != 0) {
                byte[] nextBytes = new byte[(int)(endFilePosition - filePosition - (long)bytes)];
                int nextLength = this.read(filePosition + (long)bytes, nextBytes);
                for (int i = 0; i < nextLength; ++i) {
                    chunk[bytes + i] = nextBytes[i];
                }
            }
            n = bytes;
        }
        catch (IOException e) {
            block8: {
                try {
                    if (e.getMessage().contains("HTTP") && e.getMessage().contains(" 416 ")) break block8;
                    throw e;
                }
                catch (Throwable throwable) {
                    IOUtils.disconnectIfPossible(connection);
                    throw throwable;
                }
            }
            IOUtils.disconnectIfPossible(connection);
            return -1;
        }
        IOUtils.disconnectIfPossible(connection);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readAll() throws IOException {
        if (this.raFile != null) {
            byte[] buf = null;
            this.raFile.seek(0L);
            buf = new byte[(int)this.raFile.length()];
            this.raFile.read(buf);
            return buf;
        }
        HttpURLConnection connection = null;
        InputStream in = null;
        ByteArrayOutputStream out = null;
        try {
            connection = (HttpURLConnection)this.url.openConnection();
            in = connection.getInputStream();
            out = new ByteArrayOutputStream();
            IOUtils.copy(in, out);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
            IOUtils.disconnectIfPossible(connection);
        }
        if (out != null) {
            return out.toByteArray();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws IOException {
        if (this.raFile != null) {
            return this.raFile.length();
        }
        if (this.length == null) {
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection)this.url.openConnection();
                String string = connection.getHeaderField("content-length");
                if (string == null) {
                    throw new IOException("content-length unavailable for " + this.url);
                }
                this.length = Long.parseLong(connection.getHeaderField("content-length"));
            }
            catch (Throwable throwable) {
                IOUtils.disconnectIfPossible(connection);
                throw throwable;
            }
            IOUtils.disconnectIfPossible(connection);
        }
        return this.length;
    }

    public RandomAccessFile getFile() {
        return this.raFile;
    }

    public void close() {
        if (this.raFile != null) {
            try {
                this.raFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.raFile = null;
        }
    }
}

