/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.BpCoordFileRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.TabixDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.ParsedFileResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.broad.tribble.readers.TabixReader;

public abstract class TabixFileFetcherThread
extends Thread {
    protected BlockingQueue<BpCoordFileRequest> fileRequestQueue;
    protected ConcurrentLinkedQueue<ParsedFileResult> fileResultQueue;
    protected TabixDataSource dataSource;
    protected boolean poison = false;

    @Override
    public void run() {
        this.setName(this.getClass().getName());
        while (!this.poison) {
            try {
                for (BpCoordFileRequest fileRequest : this.fileRequestQueue) {
                    if (!fileRequest.getStatus().poison) continue;
                    this.poison = true;
                }
                this.processFileRequest(this.fileRequestQueue.take());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected abstract void processFileRequest(BpCoordFileRequest var1) throws IOException;

    protected TabixReader.Iterator getTabixIterator(Region request) {
        String chromosome = request.start.chr.toNormalisedString();
        int start = (int)Math.min(Integer.MAX_VALUE, request.start.bp);
        int end = (int)Math.min(Integer.MAX_VALUE, request.end.bp);
        int EXTRA = 500000;
        start = (int)Math.max((long)start - (long)EXTRA, 1L);
        end = (int)Math.min((long)end + (long)EXTRA, Integer.MAX_VALUE);
        int MAX_BIN_SIZE = 0x1FFFFFFE;
        start = Math.min(MAX_BIN_SIZE, start);
        end = Math.min(MAX_BIN_SIZE, end);
        start = Math.max(1, start);
        end = Math.max(1, end);
        String queryRegion = chromosome + ":" + start + "-" + end;
        TabixReader.Iterator iter = null;
        try {
            iter = this.dataSource.getReader().query(queryRegion);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        return iter;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " - " + this.dataSource;
    }
}

