/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client;

import fi.csc.microarray.client.AtEndListener;
import fi.csc.microarray.client.Authenticator;
import fi.csc.microarray.client.ClientConstants;
import fi.csc.microarray.client.LocalServiceAccessor;
import fi.csc.microarray.client.RemoteServiceAccessor;
import fi.csc.microarray.client.ServiceAccessor;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.dataimport.ImportItem;
import fi.csc.microarray.client.dataimport.ImportSession;
import fi.csc.microarray.client.dataimport.ImportUtils;
import fi.csc.microarray.client.dialog.ChipsterDialog;
import fi.csc.microarray.client.dialog.DialogInfo;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.client.operation.ToolCategory;
import fi.csc.microarray.client.operation.ToolModule;
import fi.csc.microarray.client.selection.DataSelectionManager;
import fi.csc.microarray.client.session.UserSession;
import fi.csc.microarray.client.tasks.Task;
import fi.csc.microarray.client.tasks.TaskEventListener;
import fi.csc.microarray.client.tasks.TaskException;
import fi.csc.microarray.client.tasks.TaskExecutor;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrameManager;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.VisualisationMethodChangedEvent;
import fi.csc.microarray.client.workflow.WorkflowManager;
import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataChangeEvent;
import fi.csc.microarray.databeans.DataChangeListener;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.messaging.SourceMessageListener;
import fi.csc.microarray.messaging.auth.AuthenticationRequestListener;
import fi.csc.microarray.messaging.auth.ClientLoginListener;
import fi.csc.microarray.module.Module;
import fi.csc.microarray.module.ModuleManager;
import fi.csc.microarray.util.Files;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.log4j.Logger;
import org.eclipse.jetty.util.IO;

public abstract class ClientApplication {
    protected static final String ALIVE_SIGNAL_FILENAME = "i_am_alive";
    protected static final int MEMORY_CHECK_INTERVAL = 2000;
    protected static final int SESSION_BACKUP_INTERVAL = 5000;
    protected static Logger logger;
    private PropertyChangeListener jobExecutorChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ClientApplication.this.taskCountChanged((Integer)evt.getNewValue(), true);
            logger.debug((Object)("JobExecutor property changed event: " + evt.getPropertyName() + ": " + (Integer)evt.getNewValue()));
        }
    };
    protected String metadata;
    protected CountDownLatch definitionsInitialisedLatch = new CountDownLatch(1);
    private boolean eventsEnabled = false;
    private PropertyChangeSupport eventSupport = new PropertyChangeSupport(this);
    protected String requestedModule;
    protected LinkedList<ToolModule> toolModules = new LinkedList();
    protected WorkflowManager workflowManager;
    protected DataManager manager;
    protected DataSelectionManager selectionManager;
    protected ServiceAccessor serviceAccessor;
    protected TaskExecutor taskExecutor;
    protected boolean isStandalone;
    private AuthenticationRequestListener overridingARL;
    protected boolean unsavedChanges = false;
    protected boolean unbackuppedChanges = false;
    protected File aliveSignalFile;
    private LinkedList<File> deadDirectories = new LinkedList();
    protected ClientConstants clientConstants;
    protected Configuration configuration = DirectoryLayout.getInstance().getConfiguration();
    private String initialisationWarnings = "";

    protected abstract void initialiseGUI() throws MicroarrayException, IOException;

    protected abstract void taskCountChanged(int var1, boolean var2);

    public abstract void reportException(Exception var1);

    public abstract void reportTaskError(Task var1) throws MicroarrayException;

    public abstract void importGroup(Collection<ImportItem> var1, String var2);

    public abstract DataFolder initializeFolderForImport(String var1);

    public abstract void showSourceFor(String var1) throws TaskException;

    public abstract void showHistoryScreenFor(DataBean var1);

    public abstract void showDetailsFor(DataBean var1);

    public abstract void showPopupMenuFor(MouseEvent var1, DataItem var2);

    public abstract void showPopupMenuFor(MouseEvent var1, List<DataItem> var2);

    public abstract void showImportToolFor(File var1, String var2, boolean var3);

    public abstract void visualiseWithBestMethod(VisualisationFrameManager.FrameType var1);

    public abstract void reportInitialisation(String var1, boolean var2);

    public abstract Icon getIconFor(DataItem var1);

    public abstract void viewHelp(String var1);

    public abstract void viewHelpFor(OperationDefinition var1);

    public abstract void showDialog(String var1, String var2, String var3, DialogInfo.Severity var4, boolean var5);

    public abstract void showDialog(String var1, String var2, String var3, DialogInfo.Severity var4, boolean var5, ChipsterDialog.DetailsVisibility var6, ChipsterDialog.PluginButton var7);

    public abstract void showDialog(String var1, String var2, String var3, DialogInfo.Severity var4, boolean var5, ChipsterDialog.DetailsVisibility var6, ChipsterDialog.PluginButton var7, boolean var8);

    public abstract void deleteDatas(DataItem ... var1);

    public abstract void createLink(DataBean var1, DataBean var2, DataBean.Link var3);

    public abstract void removeLink(DataBean var1, DataBean var2, DataBean.Link var3);

    public abstract File saveWorkflow();

    public abstract File openWorkflow();

    public abstract void loadSession();

    public abstract void loadSessionFrom(URL var1);

    public abstract void loadSessionFrom(File var1);

    public abstract void restoreSessionFrom(File var1);

    public abstract void saveSession();

    public abstract void runWorkflow(URL var1);

    public abstract void runWorkflow(URL var1, AtEndListener var2);

    public abstract void flipTaskListVisibility(boolean var1);

    public abstract void setMaximisedVisualisationMode(boolean var1);

    public abstract VisualisationFrameManager getVisualisationFrameManager();

    public abstract void runBlockingTask(String var1, Runnable var2);

    public abstract DataManager getDataManager();

    public abstract void checkFreeMemory();

    public ClientApplication() {
        this(false, null);
    }

    public ClientApplication(boolean isStandalone, AuthenticationRequestListener overridingARL) {
        this.clientConstants = new ClientConstants();
        this.serviceAccessor = isStandalone ? new LocalServiceAccessor() : new RemoteServiceAccessor();
        this.isStandalone = isStandalone;
        this.overridingARL = overridingARL;
    }

    protected void initialiseApplication() throws MicroarrayException, IOException {
        logger = Logger.getLogger(ClientApplication.class);
        try {
            ModuleManager modules = new ModuleManager(this.requestedModule);
            Session.getSession().setModuleManager(modules);
            this.workflowManager = new WorkflowManager(this);
            this.manager = new DataManager();
            Session.getSession().setDataManager(this.manager);
            modules.plugAll(this.manager, Session.getSession());
            this.selectionManager = new DataSelectionManager(this);
            Session.getSession().setClientApplication(this);
            logger.debug((Object)"Initialise JMS connection.");
            this.reportInitialisation("Connecting to broker at " + this.configuration.getString("messaging", "broker-host") + "...", true);
            this.serviceAccessor.initialise(this.manager, this.getAuthenticationRequestListener());
            this.taskExecutor = this.serviceAccessor.getTaskExecutor();
            Session.getSession().setServiceAccessor(this.serviceAccessor);
            this.reportInitialisation(" ok", false);
            this.reportInitialisation("Checking remote services...", true);
            String status = this.serviceAccessor.checkRemoteServices();
            if (!"ok".equals(status)) {
                throw new Exception(status);
            }
            this.reportInitialisation(" ok", false);
            this.reportInitialisation("Fetching analysis descriptions...", true);
            this.initialisationWarnings = this.initialisationWarnings + this.serviceAccessor.fetchDescriptions(modules.getPrimaryModule());
            this.toolModules.addAll(this.serviceAccessor.getModules());
            if (!this.isStandalone) {
                LocalServiceAccessor localServiceAccessor = new LocalServiceAccessor();
                localServiceAccessor.initialise(this.manager, null);
                localServiceAccessor.fetchDescriptions(modules.getPrimaryModule());
                this.toolModules.addAll(localServiceAccessor.getModules());
            }
            ToolCategory internalCategory = new ToolCategory("Internal tools");
            internalCategory.addOperation(OperationDefinition.IMPORT_DEFINITION);
            internalCategory.addOperation(OperationDefinition.CREATE_DEFINITION);
            ToolModule internalModule = new ToolModule("internal");
            internalModule.addHiddenToolCategory(internalCategory);
            this.toolModules.add(internalModule);
            this.reportInitialisation(" ok", false);
            this.taskExecutor.addChangeListener(this.jobExecutorChangeListener);
            this.definitionsInitialisedLatch.countDown();
            this.initialiseGUI();
            this.manager.addDataChangeListener(new DataChangeListener(){

                @Override
                public void dataChanged(DataChangeEvent event) {
                    ClientApplication.this.unsavedChanges = true;
                    ClientApplication.this.unbackuppedChanges = true;
                }
            });
            Timer memoryCheckTimer = new Timer(2000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClientApplication.this.checkFreeMemory();
                }
            });
            memoryCheckTimer.setCoalesce(true);
            memoryCheckTimer.setRepeats(true);
            memoryCheckTimer.setInitialDelay(0);
            memoryCheckTimer.start();
            this.aliveSignalFile = new File(this.manager.getRepository(), ALIVE_SIGNAL_FILENAME);
            this.aliveSignalFile.createNewFile();
            this.aliveSignalFile.deleteOnExit();
            Timer timer = new Timer(5000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClientApplication.this.aliveSignalFile.setLastModified(System.currentTimeMillis());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (ClientApplication.this.unbackuppedChanges) {
                                File sessionFile = UserSession.findBackupFile(ClientApplication.this.getDataManager().getRepository(), true);
                                sessionFile.deleteOnExit();
                                try {
                                    ClientApplication.this.getDataManager().saveLightweightSession(sessionFile);
                                }
                                catch (Exception e) {
                                    logger.warn((Object)e);
                                }
                            }
                            ClientApplication.this.unbackuppedChanges = false;
                        }
                    });
                }
            });
            timer.setCoalesce(true);
            timer.setRepeats(true);
            timer.setInitialDelay(5000);
            timer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MicroarrayException(e);
        }
    }

    public void addClientEventListener(PropertyChangeListener listener) {
        this.eventSupport.addPropertyChangeListener(listener);
    }

    public void removeClientEventListener(PropertyChangeListener listener) {
        this.eventSupport.removePropertyChangeListener(listener);
    }

    public DataSelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public void selectAllItems() {
        List<DataBean> datas = this.manager.databeans();
        for (DataBean data : datas) {
            this.selectionManager.selectMultiple(data, (Object)this);
        }
    }

    public void setVisualisationMethod(VisualisationMethod method, List<Visualisation.Variable> variables, List<DataBean> datas, VisualisationFrameManager.FrameType target) {
        this.fireClientEvent(new VisualisationMethodChangedEvent(this, method, variables, datas, target));
    }

    public void setVisualisationMethod(VisualisationMethodChangedEvent e) {
        this.fireClientEvent(e);
    }

    public void setEventsEnabled(boolean eventsEnabled) {
        this.eventsEnabled = eventsEnabled;
        this.taskExecutor.setEventsEnabled(eventsEnabled);
    }

    public void renameDataItem(DataItem data, String newName) {
        data.setName(newName);
    }

    public void executeOperation(final Operation operation) {
        if (Session.getSession().getUsername() != null && Session.getSession().getUsername().equals(this.configuration.getString("security", "guest-username"))) {
            this.showDialog("Running tools is disabled for guest users.", "", null, DialogInfo.Severity.INFO, true, ChipsterDialog.DetailsVisibility.DETAILS_ALWAYS_HIDDEN, null);
            return;
        }
        if (this.taskExecutor.getRunningTaskCount() >= this.clientConstants.MAX_JOBS) {
            this.showDialog("Task not started as there are maximum number of tasks already running.", "You can only run " + this.clientConstants.MAX_JOBS + " tasks at the same time. Please wait for one of the currently running tasks to finish and try again.", null, DialogInfo.Severity.INFO, false);
            return;
        }
        Task task = this.taskExecutor.createTask(operation);
        task.addTaskEventListener(new TaskEventListener(){

            @Override
            public void onStateChange(Task job, Task.State oldState, Task.State newState) {
                if (newState.isFinished()) {
                    try {
                        ClientApplication.this.onFinishedTask(job, operation);
                    }
                    catch (Exception e) {
                        ClientApplication.this.reportException(e);
                    }
                }
            }
        });
        try {
            this.taskExecutor.startExecuting(task);
        }
        catch (TaskException te) {
            this.reportException(te);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFinishedTask(Task task, Operation oper) throws MicroarrayException, IOException {
        block21: {
            LinkedList<DataBean> newBeans = new LinkedList<DataBean>();
            try {
                logger.debug((Object)("operation finished, state is " + (Object)((Object)task.getState())));
                if (task.getState() == Task.State.CANCELLED) {
                    break block21;
                }
                if (!task.getState().finishedSuccesfully()) {
                    this.reportTaskError(task);
                    break block21;
                }
                newBeans = new LinkedList();
                Module primaryModule = Session.getSession().getPrimaryModule();
                LinkedList<DataBean> sources = new LinkedList<DataBean>();
                for (Operation.DataBinding binding : oper.getBindings()) {
                    if (primaryModule.isMetadata(binding.getData()) || binding.getData().getParent() == null) continue;
                    sources.add(binding.getData());
                }
                DataFolder folder = null;
                if (oper.getOutputFolder() != null) {
                    folder = oper.getOutputFolder();
                } else if (sources.size() > 0) {
                    for (DataBean source : sources) {
                        if (source.getParent() == null) continue;
                        folder = source.getParent();
                    }
                }
                if (folder == null) {
                    folder = this.manager.getRootFolder();
                }
                DataBean metadataOutput = null;
                OperationRecord operationRecord = new OperationRecord(oper);
                operationRecord.setSourceCode(task.getSourceCode());
                for (String outputName : task.outputNames()) {
                    DataBean output = task.getOutput(outputName);
                    output.setOperationRecord(operationRecord);
                    for (DataBean source : sources) {
                        output.addLink(DataBean.Link.DERIVATION, source);
                    }
                    try {
                        output.initialiseStreamStartCache();
                    }
                    catch (IOException e) {
                        throw new MicroarrayException(e);
                    }
                    folder.addChild(output);
                    if (primaryModule.isMetadata(output)) {
                        metadataOutput = output;
                    }
                    newBeans.add(output);
                }
                if (metadataOutput != null) {
                    for (DataBean bean : newBeans) {
                        if (bean == metadataOutput) continue;
                        metadataOutput.addLink(DataBean.Link.ANNOTATION, bean);
                    }
                    primaryModule.postProcessOutputMetadata(oper, metadataOutput);
                }
            }
            finally {
                if (oper.getResultListener() != null) {
                    if (task.getState().finishedSuccesfully()) {
                        oper.getResultListener().resultData(newBeans);
                    } else {
                        oper.getResultListener().noResults();
                    }
                }
            }
        }
    }

    protected void quit() {
        logger.debug((Object)"quitting client");
        try {
            this.serviceAccessor.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void fireClientEvent(PropertyChangeEvent event) {
        logger.debug((Object)("dispatching event: " + event));
        if (this.eventsEnabled) {
            this.eventSupport.firePropertyChange(event);
        }
    }

    public List<File> getWorkflows() {
        return this.workflowManager.getWorkflows();
    }

    public void fetchSourceFor(String[] operationIDs, SourceCodeListener listener) throws MicroarrayException {
        int i = -1;
        for (String id : operationIDs) {
            ++i;
            logger.debug((Object)("describe operation " + id));
            if (id == null) {
                listener.updateSourceCodeAt(i, null);
                continue;
            }
            SourceMessageListener sourceListener = null;
            try {
                sourceListener = this.serviceAccessor.retrieveSourceCode(id);
                String source = sourceListener.waitForResponse(60L, TimeUnit.SECONDS);
                listener.updateSourceCodeAt(i, source);
            }
            catch (Exception e) {
                throw new MicroarrayException(e);
            }
            finally {
                if (sourceListener != null) {
                    sourceListener.cleanUp();
                }
            }
        }
    }

    public void importWholeDirectory(File root) {
        LinkedList<File> onlyFiles = new LinkedList<File>();
        for (File file : root.listFiles()) {
            if (!file.isFile()) continue;
            onlyFiles.add(file);
        }
        ImportSession importSession = new ImportSession(ImportSession.Source.CLIPBOARD, onlyFiles, root.getName(), true);
        ImportUtils.executeImport(importSession);
    }

    public OperationDefinition getOperationDefinition(String toolId) {
        for (ToolModule module : this.toolModules) {
            OperationDefinition tool = module.getOperationDefinition(toolId);
            if (tool == null) continue;
            return tool;
        }
        return null;
    }

    public OperationDefinition getOperationDefinitionBestMatch(String toolId, String moduleName, String categoryName) {
        ToolModule preferredModule = this.getModule(moduleName);
        if (preferredModule != null) {
            OperationDefinition preferredTool = preferredModule.getOperationDefinition(toolId, categoryName);
            if (preferredTool != null) {
                return preferredTool;
            }
            preferredTool = preferredModule.getOperationDefinition(toolId);
            if (preferredTool != null) {
                return preferredTool;
            }
        } else {
            OperationDefinition toolWithCategoryMismatch = null;
            for (ToolModule module : this.toolModules) {
                OperationDefinition tool = module.getOperationDefinition(toolId, categoryName);
                if (tool != null) {
                    return tool;
                }
                tool = module.getOperationDefinition(toolId);
                if (tool == null) continue;
                toolWithCategoryMismatch = tool;
            }
            return toolWithCategoryMismatch;
        }
        return null;
    }

    protected void exportToFile(final DataBean data, final File selectedFile) {
        this.runBlockingTask("exporting file", new Runnable(){

            @Override
            public void run() {
                try {
                    File newFile = selectedFile;
                    int i = 1;
                    while (newFile.exists()) {
                        String[] parts = Files.parseFilename(selectedFile);
                        newFile = new File(parts[0] + File.separator + parts[1] + "_" + ++i + "." + parts[2]);
                    }
                    newFile.createNewFile();
                    FileOutputStream out = new FileOutputStream(newFile);
                    IO.copy((InputStream)data.getContentByteStream(), (OutputStream)out);
                    out.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    protected AuthenticationRequestListener getAuthenticationRequestListener() {
        AuthenticationRequestListener authenticator = this.overridingARL != null ? this.overridingARL : new Authenticator();
        authenticator.setLoginListener(new ClientLoginListener(){

            @Override
            public void firstLogin() {
            }

            @Override
            public void loginCancelled() {
                System.exit(1);
            }
        });
        return authenticator;
    }

    public boolean isStandalone() {
        return this.isStandalone;
    }

    protected File checkTempDirectories() throws IOException {
        Iterable<File> tmpDirectories = this.getDataManager().listAllRepositories();
        File mostRecentDeadSignalFile = null;
        for (File directory : tmpDirectories) {
            if (directory.equals(this.getDataManager().getRepository())) continue;
            File aliveSignalFile = new File(directory, ALIVE_SIGNAL_FILENAME);
            long originalLastModified = aliveSignalFile.lastModified();
            while (System.currentTimeMillis() - aliveSignalFile.lastModified() < 10000L) {
                if (UserSession.findBackupFile(directory, false) == null || aliveSignalFile.lastModified() != originalLastModified) continue;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
            this.deadDirectories.add(directory);
            File deadSignalFile = new File(directory, ALIVE_SIGNAL_FILENAME);
            if (UserSession.findBackupFile(directory, false) == null || mostRecentDeadSignalFile != null && mostRecentDeadSignalFile.lastModified() >= deadSignalFile.lastModified()) continue;
            mostRecentDeadSignalFile = deadSignalFile;
        }
        return mostRecentDeadSignalFile != null ? mostRecentDeadSignalFile.getParentFile() : null;
    }

    public void clearDeadTempDirectories() {
        try {
            for (File dir : this.deadDirectories) {
                Files.delTree(dir);
            }
        }
        catch (Exception e) {
            this.reportException(e);
        }
        this.deadDirectories.clear();
    }

    private ToolModule getModule(String moduleName) {
        for (ToolModule toolModule : this.toolModules) {
            if (!toolModule.getModuleName().equals(moduleName)) continue;
            return toolModule;
        }
        return null;
    }

    public String getInitialisationWarnings() {
        return this.initialisationWarnings;
    }

    public static interface SourceCodeListener {
        public void updateSourceCodeAt(int var1, String var2);
    }
}

