/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.processor.Traceable;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilterProcessor
extends DelegateAsyncProcessor
implements Traceable {
    private static final Log LOG = LogFactory.getLog(FilterProcessor.class);
    private final Predicate predicate;

    public FilterProcessor(Predicate predicate, Processor processor) {
        super(processor);
        this.predicate = predicate;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        boolean matches = false;
        try {
            matches = this.predicate.matches(exchange);
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Filter matches: " + matches + " for exchange: " + exchange));
        }
        if (matches) {
            return super.process(exchange, callback);
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return "Filter[if: " + this.predicate + " do: " + this.getProcessor() + "]";
    }

    public String getTraceLabel() {
        return "filter[if: " + this.predicate + "]";
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService(this.predicate);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.predicate);
        super.doStop();
    }
}

