/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.Consumer;
import org.apache.camel.Route;
import org.apache.camel.impl.RouteService;
import org.apache.camel.spi.RouteStartupOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRouteStartupOrder
implements RouteStartupOrder {
    private final int startupOrder;
    private final Route route;
    private final RouteService routeService;

    public DefaultRouteStartupOrder(int startupOrder, Route route, RouteService routeService) {
        this.startupOrder = startupOrder;
        this.route = route;
        this.routeService = routeService;
    }

    @Override
    public int getStartupOrder() {
        return this.startupOrder;
    }

    @Override
    public Route getRoute() {
        return this.route;
    }

    @Override
    public List<Consumer> getInputs() {
        ArrayList<Consumer> answer = new ArrayList<Consumer>();
        Map<Route, Consumer> inputs = this.routeService.getInputs();
        for (Consumer consumer : inputs.values()) {
            answer.add(consumer);
        }
        return answer;
    }

    public RouteService getRouteService() {
        return this.routeService;
    }

    public String toString() {
        return "Route " + this.route.getId() + " starts in order " + this.startupOrder;
    }
}

