/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RouteNode;
import org.apache.camel.management.InstrumentationProcessor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.Traceable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRouteNode
implements RouteNode {
    private Expression expression;
    private Processor processor;
    private ProcessorDefinition<?> processorDefinition;

    public DefaultRouteNode(ProcessorDefinition<?> processorDefinition, Processor processor) {
        this.processor = processor;
        this.processorDefinition = processorDefinition;
    }

    public DefaultRouteNode(ProcessorDefinition<?> processorDefinition, Expression expression) {
        this.processorDefinition = processorDefinition;
        this.expression = expression;
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public ProcessorDefinition<?> getProcessorDefinition() {
        return this.processorDefinition;
    }

    @Override
    public String getLabel(Exchange exchange) {
        if (this.expression != null) {
            return this.expression.evaluate(exchange, String.class);
        }
        Processor target = this.processor;
        if (target != null) {
            if (target instanceof InstrumentationProcessor) {
                target = ((InstrumentationProcessor)target).getProcessor();
            }
            if (target instanceof Traceable) {
                Traceable trace = (Traceable)((Object)target);
                return trace.getTraceLabel();
            }
        }
        return this.processorDefinition.getLabel();
    }

    @Override
    public boolean isAbstract() {
        return this.processor == null;
    }

    public String toString() {
        return "RouteNode[" + this.processorDefinition + "]";
    }
}

