/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.draw;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import org.emboss.jemboss.draw.Block;
import org.emboss.jemboss.draw.EmbossCirdnaReader;
import org.emboss.jemboss.draw.GeneticMarker;
import org.emboss.jemboss.draw.LineAttribute;
import org.emboss.jemboss.draw.PrintDNAImage;
import org.emboss.jemboss.draw.RestrictionEnzyme;
import org.emboss.jemboss.draw.Ticks;
import org.emboss.jemboss.draw.Wizard;
import org.emboss.jemboss.gui.Browser;
import org.emboss.jemboss.gui.ScrollPanel;

public class DNADraw
extends ScrollPanel
implements Printable,
DragGestureListener,
DragSourceListener,
DropTargetListener {
    public static JScrollPane jsp;
    private DNADraw current_dna;
    private JFrame mainFrame;
    private Point location = new Point(75, 75);
    private Dimension border = new Dimension(150, 150);
    private Dimension panelSize = new Dimension(600, 600);
    private Dimension linearPanelSize = new Dimension(800, 350);
    private Hashtable lineAttr;
    private Vector minorTicks;
    private Vector majorTicks;
    private Vector block;
    private Vector restrictionEnzyme;
    private int startTick = 0;
    private int minorTick = 100;
    private int majorTick = 500;
    private int[] tickMajorXPositions;
    private int[] tickMajorYPositions;
    private int[] tickMinorXPositions;
    private int[] tickMinorYPositions;
    private int[] reXPositions;
    private int[] reYPositions;
    private boolean close = false;

    public DNADraw() {
        super(new BorderLayout());
        this.current_dna = this;
        this.setBackground(Color.white);
        this.setPreferredSize(this.panelSize);
        this.setOpaque(false);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        this.setDropTarget(new DropTarget(this, this));
        this.lineAttr = new Hashtable();
        this.lineAttr.put("start", new Integer(0));
        this.lineAttr.put("end", new Integer(4000));
        this.lineAttr.put("lsize", new Integer(5));
        this.lineAttr.put("circular", new Boolean(true));
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && !mouseEvent.isPopupTrigger()) {
                    for (int i = 0; i < DNADraw.this.getComponentCount(); ++i) {
                        Block block;
                        if (!(DNADraw.this.getComponent(i) instanceof Block) || !(block = (Block)DNADraw.this.getComponent(i)).isOverMe(mouseEvent.getX(), mouseEvent.getY())) continue;
                        final JFrame jFrame = new JFrame("Properties");
                        JButton jButton = new JButton("Delete");
                        jButton.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                DNADraw.this.remove(block);
                                DNADraw.this.current_dna.repaint();
                                jFrame.setVisible(false);
                                jFrame.dispose();
                                Enumeration enumeration = DNADraw.this.block.elements();
                                int n = 0;
                                while (enumeration.hasMoreElements()) {
                                    Vector vector = (Vector)enumeration.nextElement();
                                    if (vector.contains(block)) {
                                        DNADraw.this.block.removeElementAt(n);
                                    }
                                    ++n;
                                }
                            }
                        });
                        block.showProperties(jFrame, DNADraw.this, jButton);
                    }
                }
            }
        };
        this.addMouseListener(mouseAdapter);
    }

    public DNADraw(Vector vector, Vector vector2, Vector vector3, Vector vector4) {
        this();
        this.minorTicks = vector;
        this.block = vector3;
        this.restrictionEnzyme = vector4;
    }

    public DNADraw(Vector vector, Vector vector2, Hashtable hashtable, int n, int n2, int n3) {
        this();
        this.block = vector;
        this.restrictionEnzyme = vector2;
        this.lineAttr = hashtable;
        this.startTick = n;
        this.minorTick = n2;
        this.majorTick = n3;
        if (!this.isCircular()) {
            this.setPreferredSize(this.linearPanelSize);
        }
        this.calculateTickPosistions();
    }

    protected double getDiameter() {
        return (double)this.getWidth() - this.border.getWidth();
    }

    protected Point getLocationPoint() {
        return this.location;
    }

    protected void zoomIn() {
        int n = this.getWidth();
        n += (int)((double)n * 0.1);
        int n2 = this.getHeight();
        if (this.isCircular()) {
            n2 += (int)((double)n2 * 0.1);
        }
        this.zoom(n, n2);
    }

    protected void zoomOut() {
        int n = this.getWidth();
        n -= (int)((double)n * 0.1);
        int n2 = this.getHeight();
        if (this.isCircular()) {
            n2 -= (int)((double)n2 * 0.1);
        }
        this.zoom(n, n2);
    }

    private void zoom(int n, int n2) {
        if (this.isCircular()) {
            this.panelSize = new Dimension(n, n2);
            this.setPreferredSize(this.panelSize);
            this.setSize(this.panelSize);
        } else {
            this.linearPanelSize = new Dimension(n, n2);
            this.setPreferredSize(this.linearPanelSize);
            this.setSize(this.linearPanelSize);
        }
        this.repaint();
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.isCircular()) {
            this.drawCircularPanel(graphics2D, true);
        } else {
            this.drawLinearPanel(graphics2D);
        }
    }

    protected boolean isCircular() {
        return (Boolean)this.lineAttr.get("circular");
    }

    protected void addBlock(Block block) {
        this.add(block);
        this.validate();
    }

    protected void drawLinearPanel(Graphics2D graphics2D) {
        int n;
        int n2;
        int n3;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        double d = fontMetrics.getAscent();
        graphics2D.setColor(Color.black);
        double d2 = 4.0;
        int n4 = 5;
        try {
            n4 = this.getLineSize();
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("No line size specified using default!");
        }
        graphics2D.setStroke(new BasicStroke(n4));
        double d3 = this.getWidth();
        double d4 = d3 - this.border.getWidth();
        int n5 = (int)d4;
        int n6 = this.getHeight() / 2;
        graphics2D.setStroke(new BasicStroke(n4));
        graphics2D.drawLine(this.location.x, n6, n5, n6);
        int n7 = this.getStart();
        int n8 = this.getEnd();
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(1.0f));
        if (this.majorTicks == null || this.minorTicks == null) {
            this.calculateTickPosistions();
        }
        Enumeration enumeration = this.minorTicks.elements();
        while (enumeration.hasMoreElements()) {
            n3 = (Integer)enumeration.nextElement();
            n2 = (n5 - this.location.x) * (n3 - n7) / (n8 - n7) + this.location.x;
            n = n6 + (int)(((double)n4 + d2) / 2.0);
            graphics2D.drawLine(n2, n6, n2, n);
        }
        enumeration = this.majorTicks.elements();
        while (enumeration.hasMoreElements()) {
            n3 = (Integer)enumeration.nextElement();
            n2 = (n5 - this.location.x) * (n3 - n7) / (n8 - n7) + this.location.x;
            n = n6 + n4 / 2 + (int)d2;
            graphics2D.drawLine(n2, n6, n2, n);
            String string = Integer.toString(n3);
            n = (int)((double)n + d);
            graphics2D.drawString(string, n2 -= fontMetrics.stringWidth(string) / 2, n);
        }
        if (this.restrictionEnzyme != null) {
            enumeration = this.restrictionEnzyme.elements();
            while (enumeration.hasMoreElements()) {
                Vector vector = (Vector)enumeration.nextElement();
                String string = (String)vector.elementAt(0);
                n = (Integer)vector.elementAt(1);
                graphics2D.setColor((Color)vector.elementAt(2));
                int n9 = (n5 - this.location.x) * (n - n7) / (n8 - n7) + this.location.x;
                int n10 = n6 - n4 / 2 - (int)d2;
                graphics2D.drawLine(n9, n6, n9, n10);
                n10 = (int)((double)n10 - d);
                graphics2D.drawString(string, n9 -= fontMetrics.stringWidth(string) / 2, n10);
            }
        }
    }

    protected void drawCircularPanel(Graphics2D graphics2D, boolean bl) {
        graphics2D.setColor(Color.black);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        double d = fontMetrics.getAscent();
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        double d4 = 360.0;
        double d5 = Math.PI;
        double d6 = 4.0;
        double d7 = d2 - this.border.getWidth();
        double d8 = d7 / 2.0;
        int n = (int)d7;
        int n2 = 5;
        try {
            n2 = this.getLineSize();
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("No line size specified using default!");
        }
        graphics2D.setStroke(new BasicStroke(n2));
        graphics2D.drawArc(this.location.x, this.location.y, n, n, 0, 360);
        AffineTransform affineTransform = graphics2D.getTransform();
        if (this.restrictionEnzyme != null) {
            if (bl) {
                int n3 = this.restrictionEnzyme.size();
                this.reXPositions = new int[n3];
                this.reYPositions = new int[n3];
            }
            Enumeration enumeration = this.restrictionEnzyme.elements();
            while (enumeration.hasMoreElements()) {
                int n4;
                Vector vector = (Vector)enumeration.nextElement();
                String string = (String)vector.elementAt(0);
                int n5 = (Integer)vector.elementAt(1);
                graphics2D.setColor((Color)vector.elementAt(2));
                double d9 = this.getAngleFromPosition(n5, d4);
                AffineTransform affineTransform2 = (AffineTransform)affineTransform.clone();
                affineTransform2.rotate(Math.toRadians(-d9), d2 / 2.0, d3 / 2.0);
                int n6 = (n2 + fontMetrics.stringWidth(string)) / 2;
                int n7 = (int)(d6 + d6 + (double)n2) + n6;
                int n8 = 0;
                int n9 = 0;
                if (bl) {
                    n8 = (int)(d8 + affineTransform2.getScaleX() * (d8 + 10.0 + (double)n6 + (double)n7) - (double)n6);
                    n9 = (int)(d8 + affineTransform2.getShearY() * (d8 + 10.0 + (double)n7 + d / 2.0) + d / 2.0);
                    n4 = this.restrictionEnzyme.indexOf(vector);
                    this.reXPositions[n4] = n8;
                    this.reYPositions[n4] = n9;
                } else {
                    n4 = this.restrictionEnzyme.indexOf(vector);
                    n8 = this.reXPositions[n4];
                    n9 = this.reYPositions[n4];
                }
                graphics2D.drawString(string, this.location.x + n8, this.location.y + n9);
                graphics2D.setTransform(affineTransform2);
                graphics2D.setStroke(new BasicStroke(1.0f));
                n4 = this.location.x + (int)d7;
                int n10 = this.location.y + (int)(d7 / 2.0);
                graphics2D.drawLine(n4, n10, n4 + n7, n10);
                graphics2D.setTransform(affineTransform);
            }
        }
        if (this.majorTicks == null || this.minorTicks == null) {
            this.calculateTickPosistions();
        }
        this.drawCircularTicks(graphics2D, d7, d8, n, affineTransform, d2, d3, d4, d5, d6, fontMetrics, n2, bl, this.majorTicks, false);
        this.drawCircularTicks(graphics2D, d7, d8, n, affineTransform, d2, d3, d4, d5, d6 / 2.0, fontMetrics, n2, bl, this.minorTicks, true);
    }

    private void drawCircularTicks(Graphics2D graphics2D, double d, double d2, int n, AffineTransform affineTransform, double d3, double d4, double d5, double d6, double d7, FontMetrics fontMetrics, int n2, boolean bl, Vector vector, boolean bl2) {
        double d8 = fontMetrics.getAscent();
        graphics2D.setColor(Color.black);
        if (bl) {
            int n3 = vector.size();
            if (bl2) {
                this.tickMinorXPositions = new int[n3];
                this.tickMinorYPositions = new int[n3];
            } else {
                this.tickMajorXPositions = new int[n3];
                this.tickMajorYPositions = new int[n3];
            }
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            int n4;
            int n5 = (Integer)enumeration.nextElement();
            double d9 = Math.toRadians(-this.getAngleFromPosition(n5, d5));
            if (d9 > d6) {
                d9 -= d6 * 2.0;
            }
            AffineTransform affineTransform2 = (AffineTransform)affineTransform.clone();
            affineTransform2.rotate(d9, d3 / 2.0, d4 / 2.0);
            String string = Integer.toString(n5);
            double d10 = fontMetrics.stringWidth(string);
            int n6 = 0;
            int n7 = 0;
            if (bl) {
                n6 = (int)(d2 + affineTransform2.getScaleX() * (d7 + (double)n2 + 3.0 + ((double)n + d10) / 2.0) - d10 / 2.0);
                n7 = (int)(d2 + affineTransform2.getShearY() * (d7 + (double)n2 + 3.0 + ((double)n + d8) / 2.0) + d8 / 2.0);
                n4 = vector.indexOf(new Integer(n5));
                if (bl2) {
                    this.tickMinorXPositions[n4] = n6;
                    this.tickMinorYPositions[n4] = n7;
                } else {
                    this.tickMajorXPositions[n4] = n6;
                    this.tickMajorYPositions[n4] = n7;
                }
            } else {
                n4 = vector.indexOf(new Integer(n5));
                if (bl2) {
                    n6 = this.tickMinorXPositions[n4];
                    n7 = this.tickMinorYPositions[n4];
                }
                n6 = this.tickMajorXPositions[n4];
                n7 = this.tickMajorYPositions[n4];
            }
            if (!bl2) {
                graphics2D.drawString(string, this.location.x + n6, this.location.y + n7);
            }
            graphics2D.setTransform(affineTransform2);
            graphics2D.setStroke(new BasicStroke(1.0f));
            n4 = this.location.x + (int)d;
            int n8 = this.location.y + (int)(d / 2.0);
            graphics2D.drawLine(n4, n8, (int)((double)(n4 + n2) + d7), n8);
            graphics2D.setTransform(affineTransform);
        }
    }

    protected void calculateTickPosistions() {
        int n;
        this.minorTicks = new Vector();
        this.majorTicks = new Vector();
        int n2 = this.getStart();
        int n3 = this.getEnd();
        if (this.majorTick == 0) {
            return;
        }
        for (n = this.startTick; n < n3; n += this.majorTick) {
            if (n < n2) continue;
            this.majorTicks.add(new Integer(n));
        }
        if (this.minorTick == 0) {
            return;
        }
        for (n = this.startTick; n < n3; n += this.minorTick) {
            Integer n4 = new Integer(n);
            if (n < n2 || this.majorTicks.contains(n4)) continue;
            this.minorTicks.add(n4);
        }
    }

    protected int getStartTick() {
        return this.startTick;
    }

    protected boolean setStartTick(int n) {
        this.startTick = n;
        return n >= this.getStart() && n < this.getEnd();
    }

    protected int getTickInterval() {
        return this.majorTick;
    }

    protected boolean setTickInterval(int n) {
        if (n < this.getEnd() - this.getStart()) {
            this.majorTick = n;
            return true;
        }
        return false;
    }

    protected int getMinorTickInterval() {
        return this.minorTick;
    }

    protected boolean setMinorTickInterval(int n) {
        if (n < this.getEnd() - this.getStart()) {
            this.minorTick = n;
            return true;
        }
        return false;
    }

    protected double getAngleFromPosition(int n, double d) {
        int n2 = this.getStart();
        int n3 = this.getEnd();
        return -((double)(n - n2) * d) / (double)(n3 - n2);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.black);
        RepaintManager.currentManager(this).setDoubleBufferingEnabled(false);
        Dimension dimension = this.getSize();
        double d = dimension.width;
        double d2 = dimension.height;
        double d3 = pageFormat.getImageableHeight();
        double d4 = pageFormat.getImageableWidth();
        double d5 = d4 / d;
        int n2 = (int)Math.ceil(d5 * d2 / d3);
        if (n >= n2) {
            return 1;
        }
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.translate(0.0, (double)(-n) * d3);
        graphics2D.scale(d5, d5);
        this.drawAll(graphics2D, false);
        return 0;
    }

    public void drawAll(Graphics2D graphics2D, boolean bl) {
        if (((Boolean)this.lineAttr.get("circular")).booleanValue()) {
            this.drawCircularPanel(graphics2D, bl);
        } else {
            this.drawLinearPanel(graphics2D);
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!(this.getComponent(i) instanceof Block)) continue;
            System.out.println("Printing block " + i);
            ((Block)this.getComponent(i)).draw(graphics2D);
        }
    }

    public void doPrintActions() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this);
        printerJob.printDialog();
        try {
            printerJob.print();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setRestrictionEnzyme(Vector vector) {
        this.restrictionEnzyme = vector;
    }

    protected void setGeneticMarker(Vector vector) {
        this.block = vector;
    }

    protected Hashtable getLineAttributes() {
        return this.lineAttr;
    }

    protected void setLineAttributes(Hashtable hashtable) {
        this.lineAttr = hashtable;
    }

    protected void setLineSize(int n) {
        this.lineAttr.put("lsize", new Integer(n));
    }

    protected int getLineSize() {
        return (Integer)this.lineAttr.get("lsize");
    }

    public void setPlasmidLocation(int n, int n2) {
        this.location.setLocation(n, n2);
    }

    public JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Open");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EmbossCirdnaReader embossCirdnaReader = new EmbossCirdnaReader();
                DNADraw.this.block = embossCirdnaReader.getBlock();
                DNADraw.this.restrictionEnzyme = embossCirdnaReader.getRestrictionEnzyme();
                DNADraw.this.lineAttr.put("start", new Integer(embossCirdnaReader.getStart()));
                DNADraw.this.lineAttr.put("end", new Integer(embossCirdnaReader.getEnd()));
                DNADraw.this.current_dna = new DNADraw(DNADraw.this.block, DNADraw.this.restrictionEnzyme, DNADraw.this.lineAttr, 0, 100, 100);
                jsp.setViewportView(DNADraw.this.current_dna);
            }
        });
        jMenu.add(jMenuItem);
        jMenu.add(new JSeparator());
        JMenu jMenu2 = new JMenu("Print");
        jMenu.add(jMenu2);
        JMenuItem jMenuItem2 = new JMenuItem("Print postscript");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DNADraw.this.doPrintActions();
            }
        });
        jMenu2.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Print png/jpeg Image...");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintDNAImage printDNAImage = new PrintDNAImage(DNADraw.this.current_dna);
                printDNAImage.print();
            }
        });
        jMenu2.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Print Preview...");
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintDNAImage printDNAImage = new PrintDNAImage(DNADraw.this.current_dna);
                printDNAImage.printPreview();
            }
        });
        jMenu.add(jMenuItem4);
        jMenu.add(new JSeparator());
        JMenuItem jMenuItem5 = new JMenuItem("Exit");
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!DNADraw.this.close) {
                    System.exit(0);
                } else {
                    DNADraw.this.mainFrame.setVisible(false);
                    DNADraw.this.mainFrame.dispose();
                }
            }
        });
        jMenu.add(jMenuItem5);
        JMenu jMenu3 = new JMenu("View");
        jMenuBar.add(jMenu3);
        JMenuItem jMenuItem6 = new JMenuItem("Zoom In");
        jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DNADraw.this.zoomIn();
            }
        });
        jMenu3.add(jMenuItem6);
        JMenuItem jMenuItem7 = new JMenuItem("Zoom Out");
        jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DNADraw.this.zoomOut();
            }
        });
        jMenu3.add(jMenuItem7);
        JMenu jMenu4 = new JMenu("Options");
        jMenuBar.add(jMenu4);
        JMenuItem jMenuItem8 = new JMenuItem("DNA Wizard");
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Wizard wizard = new Wizard(DNADraw.this.current_dna);
                DNADraw.this.current_dna = wizard.getDNADraw();
                jsp.setViewportView(DNADraw.this.current_dna);
            }
        });
        jMenu4.add(jMenuItem8);
        jMenu4.add(new JSeparator());
        JMenuItem jMenuItem9 = new JMenuItem("DNA attributes");
        jMenuItem9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFrame jFrame = new JFrame("DNA Attributes");
                LineAttribute lineAttribute = new LineAttribute(DNADraw.this.current_dna);
                JScrollPane jScrollPane = new JScrollPane(lineAttribute);
                JPanel jPanel = (JPanel)jFrame.getContentPane();
                jPanel.add((Component)jScrollPane, "Center");
                jFrame.setJMenuBar(lineAttribute.createMenuBar(jFrame));
                jFrame.pack();
                jFrame.setVisible(true);
            }
        });
        jMenu4.add(jMenuItem9);
        JMenuItem jMenuItem10 = new JMenuItem("Tick marks");
        jMenuItem10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFrame jFrame = new JFrame("Tick Marks");
                Ticks ticks = new Ticks(DNADraw.this.current_dna, true);
                JScrollPane jScrollPane = new JScrollPane(ticks);
                JPanel jPanel = (JPanel)jFrame.getContentPane();
                jPanel.add((Component)jScrollPane, "Center");
                jFrame.setJMenuBar(ticks.createMenuBar(jFrame));
                jFrame.pack();
                jFrame.setVisible(true);
            }
        });
        jMenu4.add(jMenuItem10);
        JMenuItem jMenuItem11 = new JMenuItem("Genetic Features");
        jMenuItem11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFrame jFrame = new JFrame("Genetic Features");
                GeneticMarker geneticMarker = new GeneticMarker(DNADraw.this.current_dna, DNADraw.this.block);
                JScrollPane jScrollPane = new JScrollPane(geneticMarker);
                JPanel jPanel = (JPanel)jFrame.getContentPane();
                jPanel.add((Component)jScrollPane, "Center");
                jFrame.setJMenuBar(geneticMarker.createMenuBar(jFrame));
                jFrame.pack();
                jFrame.setVisible(true);
            }
        });
        jMenu4.add(jMenuItem11);
        JMenuItem jMenuItem12 = new JMenuItem("Restriction Enzyme");
        jMenuItem12.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFrame jFrame = new JFrame("Restriction Enzyme");
                RestrictionEnzyme restrictionEnzyme = new RestrictionEnzyme(DNADraw.this.current_dna, DNADraw.this.restrictionEnzyme);
                JScrollPane jScrollPane = new JScrollPane(restrictionEnzyme);
                JPanel jPanel = (JPanel)jFrame.getContentPane();
                jPanel.add((Component)jScrollPane, "Center");
                jFrame.setJMenuBar(restrictionEnzyme.createMenuBar(jFrame));
                jFrame.pack();
                jFrame.setVisible(true);
            }
        });
        jMenu4.add(jMenuItem12);
        JMenu jMenu5 = new JMenu("Help");
        jMenuBar.add(jMenu5);
        JMenuItem jMenuItem13 = new JMenuItem("About");
        jMenu5.add(jMenuItem13);
        jMenuItem13.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassLoader classLoader = this.getClass().getClassLoader();
                try {
                    URL uRL = classLoader.getResource("resources/readmeDNADraw.html");
                    new Browser(uRL, "resources/readmeAlign.html");
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, "Jemboss Alignment Viewer Guide not found!", "Error", 0);
                }
            }
        });
        return jMenuBar;
    }

    public void setCloseAndDispose(boolean bl, JFrame jFrame) {
        this.mainFrame = jFrame;
        this.close = bl;
    }

    protected Vector getGeneticMarker() {
        return this.block;
    }

    protected Vector getRestrictionEnzyme() {
        return this.restrictionEnzyme;
    }

    protected int getStart() {
        return (Integer)this.lineAttr.get("start");
    }

    protected int getEnd() {
        return (Integer)this.lineAttr.get("end");
    }

    protected void setStart(int n) {
        this.lineAttr.put("start", new Integer(n));
        this.calculateTickPosistions();
    }

    protected void setEnd(int n) {
        this.lineAttr.put("end", new Integer(n));
        this.calculateTickPosistions();
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        InputEvent inputEvent = dragGestureEvent.getTriggerEvent();
        if (inputEvent instanceof MouseEvent && ((MouseEvent)inputEvent).isPopupTrigger()) {
            return;
        }
        Point point = dragGestureEvent.getDragOrigin();
        Component component = this.getComponentAt(point);
        if (component instanceof Block) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Block block;
                if (!(this.getComponent(i) instanceof Block) || !(block = (Block)this.getComponent(i)).isOverMe(point.x, point.y)) continue;
                dragGestureEvent.startDrag(DragSource.DefaultCopyDrop, block, this);
            }
        }
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(Block.BLOCK)) {
            dropTargetDragEvent.acceptDrag(3);
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        if (transferable.isDataFlavorSupported(Block.BLOCK)) {
            try {
                Point point = dropTargetDropEvent.getLocation();
                Block block = (Block)transferable.getTransferData(Block.BLOCK);
                for (int i = 0; i < this.getComponentCount(); ++i) {
                    Block block2;
                    if (!(this.getComponent(i) instanceof Block) || !(block2 = (Block)this.getComponent(i)).getLabel().equals(block.getLabel()) || block2.getStart() != block.getStart() || block2.getEnd() != block.getEnd()) continue;
                    block2.setBlockLocation(point.x, point.y);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public static void main(String[] stringArray) {
        Wizard wizard = new Wizard(null);
        DNADraw dNADraw = wizard.getDNADraw();
        JFrame jFrame = new JFrame("DNA Viewer");
        Dimension dimension = jFrame.getToolkit().getScreenSize();
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(1200));
        vector.add(new Integer(1600));
        vector.add(new Integer(2000));
        vector.add(new Integer(2500));
        vector.add(new Integer(3000));
        vector.add(new Integer(3500));
        vector.add(new Integer(4070));
        vector.add(new Integer(4500));
        vector.add(new Integer(5070));
        Vector vector2 = new Vector();
        Vector<Object> vector3 = new Vector<Object>();
        Vector<Vector<Object>> vector4 = new Vector<Vector<Object>>();
        vector3.add(new String("CDS"));
        vector3.add(new Integer(1200));
        vector3.add(new Integer(1600));
        vector3.add(Color.red);
        vector3.add(new Float(10.0f));
        vector3.add(new Boolean(false));
        vector3.add(new Boolean(true));
        vector4.add(vector3);
        Vector vector5 = new Vector();
        Vector<Object> vector6 = new Vector<Object>();
        vector6.add(new String("EcoR1"));
        vector6.add(new Integer(2555));
        vector6.add(Color.blue);
        vector5.add(vector6);
        vector6 = new Vector();
        vector6.add(new String("EcoR1"));
        vector6.add(new Integer(3444));
        vector6.add(Color.blue);
        vector5.add(vector6);
        if (dNADraw == null) {
            dNADraw = new DNADraw(vector, vector2, vector4, vector5);
        }
        jsp = new JScrollPane(dNADraw);
        jsp.getViewport().setBackground(Color.white);
        jFrame.getContentPane().add(jsp);
        jFrame.setJMenuBar(dNADraw.createMenuBar());
        jFrame.pack();
        jFrame.setLocation(((int)dimension.getWidth() - jFrame.getWidth()) / 4, ((int)dimension.getHeight() - jFrame.getHeight()) / 2);
        jFrame.setVisible(true);
    }
}

